/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.rewards;

import ca.bradj.questown.core.init.RewardsInit;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.Reward;
import ca.bradj.questown.town.rewards.RewardType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class AddItemQuestReward
extends MCReward {
    public static final String ID = "add_item_quest_reward";
    private final TownInterface town;
    private ResourceLocation itemId;
    private int count;

    public AddItemQuestReward(TownInterface town, ResourceLocation itemIdNotTag, int count) {
        this((RewardType)RewardsInit.ITEM_QUEST.get(), town);
        this.itemId = itemIdNotTag;
        this.count = count;
    }

    private AddItemQuestReward(RewardType<AddItemQuestReward> type, TownInterface town) {
        super(type);
        this.town = town;
    }

    @Override
    public String toNiceString() {
        return this.count + "x " + this.itemId.toString();
    }

    @Override
    public boolean contains(@NotNull RewardType<?> reward) {
        return this.rType.equals(reward);
    }

    @Override
    public boolean addsQuestsWhenApplied() {
        return false;
    }

    @Override
    protected CompoundTag serializeNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("count", this.count);
        tag.m_128359_("item_id", this.itemId.toString());
        return tag;
    }

    @Override
    protected void deserializeNbt(TownInterface entity, CompoundTag tag) {
        this.count = tag.m_128451_("count");
        this.itemId = ResourceLocation.m_135820_((String)tag.m_128461_("item_id"));
    }

    @Override
    @NotNull
    protected Reward.RewardApplier getApplier() {
        return () -> this.town.getQuestHandle().addItemQuest(this.itemId, this.count);
    }

    public static AddItemQuestReward emptyForDeserializing(RewardType<? extends MCReward> rewardType, TownInterface townInterface) {
        return new AddItemQuestReward(rewardType, townInterface);
    }
}

