/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.rewards;

import ca.bradj.questown.core.init.RewardsInit;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.Reward;
import ca.bradj.questown.town.rewards.RewardType;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class AddRandomUpgradeQuest
extends MCReward {
    public static final String ID = "add_random_upgrade_quest";
    private static final String NBT_VISITOR_UUID = "visitor_uuid";
    private final TownInterface town;
    private UUID visitorUUID;

    private AddRandomUpgradeQuest(RewardType<? extends MCReward> rType, @NotNull TownInterface entity, UUID visitorUUID) {
        super(rType);
        this.visitorUUID = visitorUUID;
        this.town = entity;
    }

    public AddRandomUpgradeQuest(@NotNull TownInterface entity, @NotNull UUID visitorUUID) {
        this((RewardType<? extends MCReward>)((RewardType)RewardsInit.RANDOM_UPGRADE_FOR_VILLAGER.get()), entity, visitorUUID);
    }

    public AddRandomUpgradeQuest(RewardType<? extends MCReward> rType, TownInterface flag, RewardsInit reg) {
        this(rType, flag, (UUID)null);
    }

    @Override
    @NotNull
    protected Reward.RewardApplier getApplier() {
        return () -> this.town.getQuestHandle().addRandomUpgradeQuestForVisitor(this.visitorUUID);
    }

    @Override
    public boolean addsQuestsWhenApplied() {
        return true;
    }

    @Override
    protected CompoundTag serializeNbt() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128362_(NBT_VISITOR_UUID, this.visitorUUID);
        return compoundTag;
    }

    @Override
    protected void deserializeNbt(TownInterface entity, CompoundTag tag) {
        if (tag.m_128441_(NBT_VISITOR_UUID)) {
            this.visitorUUID = tag.m_128342_(NBT_VISITOR_UUID);
        }
    }

    @Override
    public String toNiceString() {
        return "AddRandomUpgradeQuest";
    }

    @Override
    public boolean contains(@NotNull RewardType<?> reward) {
        return this.rType.equals(reward);
    }
}

