/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.rewards;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.init.RewardsInit;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.declarative.nomc.WorkSeekerJob;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.Reward;
import ca.bradj.questown.town.rewards.RewardType;
import com.google.common.collect.ImmutableList;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ChangeJobReward
extends MCReward {
    public static final String ID = "change_job";
    private static final String NBT_VISITOR_UUID = "visitor_uuid";
    private static final String NBT_JOB_NAME = "job_name";
    private final TownInterface town;
    private UUID visitorUUID;
    private String jobName;

    public ChangeJobReward(RewardType<? extends MCReward> rType, @NotNull TownInterface entity, UUID visitorUUID, String jobName) {
        super(rType);
        this.visitorUUID = visitorUUID;
        this.town = entity;
        this.jobName = jobName;
    }

    public ChangeJobReward(@NotNull TownInterface entity, @NotNull UUID visitorUUID, @NotNull String jobName) {
        this((RewardType)RewardsInit.CHANGE_JOB.get(), entity, visitorUUID, jobName);
    }

    @Override
    @NotNull
    protected Reward.RewardApplier getApplier() {
        return () -> {
            JobID jobID = WorkSeekerJob.newIDForRoot(this.jobName);
            this.town.getVillagerHandle().changeJobForVillager(this.visitorUUID, jobID, false);
            ImmutableList<JobID> defaultWork = ServerJobsRegistry.getDefaultWork(jobID);
            defaultWork.forEach(v -> {
                ItemStack output = ServerJobsRegistry.getDefaultWorkForNewWorker(v);
                if (output.m_41619_()) {
                    return;
                }
                this.town.getWorkHandle().requestWork(output.m_41720_());
                QT.JOB_LOGGER.debug("Request was added to job board automatically");
            });
        };
    }

    @Override
    public boolean addsQuestsWhenApplied() {
        return false;
    }

    @Override
    protected CompoundTag serializeNbt() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128362_(NBT_VISITOR_UUID, this.visitorUUID);
        compoundTag.m_128359_(NBT_JOB_NAME, this.jobName);
        return compoundTag;
    }

    @Override
    protected void deserializeNbt(TownInterface entity, CompoundTag tag) {
        if (tag.m_128441_(NBT_VISITOR_UUID)) {
            this.visitorUUID = tag.m_128342_(NBT_VISITOR_UUID);
        }
        if (tag.m_128441_(NBT_JOB_NAME)) {
            this.jobName = tag.m_128461_(NBT_JOB_NAME);
        }
    }

    public String getJobName() {
        return this.jobName;
    }

    @Override
    public String toNiceString() {
        return "ChangeJob:" + this.jobName;
    }

    @Override
    public boolean contains(@NotNull RewardType<?> reward) {
        return this.rType.equals(reward);
    }
}

