/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.rewards;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.core.init.RewardsInit;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.jobs.ImmutableSnapshot;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.gatherer.GathererUnmappedNoToolWorkQtrDay;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.Reward;
import ca.bradj.questown.town.rewards.RewardType;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnVisitorReward
extends MCReward {
    public static final String ID = "spawn_visitor_reward";
    private static final String NBT_VISITOR_UUID = "visitor_uuid";
    private final TownInterface town;
    private UUID visitorUUID;

    public SpawnVisitorReward(RewardType<? extends MCReward> rType, @NotNull TownInterface entity, @Nullable UUID visitorUUID) {
        super(rType);
        this.visitorUUID = visitorUUID;
        this.town = entity;
    }

    public SpawnVisitorReward(TownInterface entity) {
        this(entity, null);
    }

    public SpawnVisitorReward(TownInterface entity, UUID visitorUUID) {
        this((RewardType)RewardsInit.VISITOR.get(), entity, visitorUUID);
    }

    @Override
    @NotNull
    protected Reward.RewardApplier getApplier() {
        return () -> SpawnVisitorReward.spawnVisitorNearby(this.town, this.visitorUUID);
    }

    private static void spawnVisitorNearby(TownInterface entity, @Nullable UUID visitorUUID) {
        ServerLevel sl = entity.getServerLevel();
        if (sl == null) {
            return;
        }
        VisitorMobEntity vEntity = new VisitorMobEntity(sl, entity);
        UUID initUUID = visitorUUID;
        if (initUUID == null) {
            initUUID = vEntity.m_20148_();
        }
        Vec3 vjp = entity.getVisitorJoinPos();
        ImmutableSnapshot<MCHeldItem, ?> initJournal = ServerJobsRegistry.getNewJournal(GathererUnmappedNoToolWorkQtrDay.ID, ProductionStatus.IDLE.name(), (ImmutableList<MCHeldItem>)ImmutableList.copyOf(Collections.nCopies(6, MCHeldItem.Air())));
        vEntity.initialize(entity, initUUID, vjp.f_82479_, vjp.f_82480_, vjp.f_82481_, initJournal);
        entity.getVillagerHandle().register(vEntity);
        sl.m_7967_((Entity)vEntity);
        QT.QUESTS_LOGGER.debug("Spawned visitor {} at {}", (Object)vEntity.m_20148_(), (Object)vEntity.m_20097_());
    }

    public String toString() {
        return "SpawnVisitorReward{town=" + String.valueOf(this.town) + ", visitorUUID=" + String.valueOf(this.visitorUUID) + "}";
    }

    @Override
    public boolean addsQuestsWhenApplied() {
        return false;
    }

    @Override
    protected CompoundTag serializeNbt() {
        CompoundTag tag = new CompoundTag();
        if (this.visitorUUID != null) {
            tag.m_128362_(NBT_VISITOR_UUID, this.visitorUUID);
        }
        return tag;
    }

    @Override
    protected void deserializeNbt(TownInterface entity, CompoundTag tag) {
        if (tag.m_128441_(NBT_VISITOR_UUID)) {
            this.visitorUUID = tag.m_128342_(NBT_VISITOR_UUID);
        }
    }

    @Override
    public String toNiceString() {
        return "SpawnNewVillager[" + UtilClean.truncateMiddle(this.visitorUUID.toString()) + "]";
    }

    @Override
    public boolean contains(@NotNull RewardType<?> reward) {
        return ((RewardType)RewardsInit.VISITOR.get()).equals(reward);
    }
}

