/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.rooms;

import ca.bradj.questown.QT;
import ca.bradj.questown.Questown;
import ca.bradj.questown.blocks.FalseDoorBlock;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.town.TownFlagBlockEntity;
import ca.bradj.questown.town.TownRooms;
import ca.bradj.questown.town.WallDetection;
import ca.bradj.questown.town.interfaces.RoomsHolder;
import ca.bradj.questown.town.rooms.MultiLevelRoomDetector;
import ca.bradj.questown.town.rooms.TownPosition;
import ca.bradj.questown.town.special.SpecialQuests;
import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatches;
import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.LevelRoomDetection;
import ca.bradj.roomrecipes.recipes.ActiveRecipes;
import ca.bradj.roomrecipes.recipes.RecipeDetection;
import ca.bradj.roomrecipes.recipes.RoomAnnouncing;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownRoomsMap
implements TownRooms.RecipeRoomChangeListener {
    private final Map<Integer, TownRooms> activeRooms = new HashMap<Integer, TownRooms>();
    private final Map<Integer, TownRooms> activeFarms = new HashMap<Integer, TownRooms>();
    private final Map<Integer, ActiveRecipes<MCRoom, RoomRecipeMatch<MCRoom>>> activeRecipes = new HashMap<Integer, ActiveRecipes<MCRoom, RoomRecipeMatch<MCRoom>>>();
    private final ArrayList<Integer> times = new ArrayList();
    @Nullable
    private MultiLevelRoomDetector pendingRooms;
    private final List<ActiveRecipes.ChangeListener<MCRoom, RoomRecipeMatch<MCRoom>>> recipeListeners = new ArrayList<ActiveRecipes.ChangeListener<MCRoom, RoomRecipeMatch<MCRoom>>>();
    @Nullable
    private TownFlagBlockEntity town;
    private final Map<TownPosition, Integer> doorsToDrop = new HashMap<TownPosition, Integer>();
    private final Set<TownPosition> registeredDoors = new HashSet<TownPosition>();
    private final Set<TownPosition> registeredFenceGates = new HashSet<TownPosition>();

    Set<TownPosition> getRegisteredDoors() {
        return this.registeredDoors;
    }

    public Set<TownPosition> getRegisteredGates() {
        return this.registeredFenceGates;
    }

    private void updateActiveFarms(ServerLevel level, int scanLevel, int scanY, Set<Position> registeredDoors) {
        TownRooms ars = this.getOrCreateFarms(scanLevel);
        ImmutableMap rooms = LevelRoomDetection.findRooms(registeredDoors, (int)20, p -> TownRoomsMap.isFence(level, Positions.ToBlock((Position)p, (int)scanY)));
        Function<Room, MCRoom> fn = z -> new MCRoom(z.getDoorPos(), (Collection)z.getSpaces(), scanY - 1);
        List<AbstractMap.SimpleEntry> array = rooms.entrySet().stream().map(v -> new AbstractMap.SimpleEntry((Position)v.getKey(), ((Optional)v.getValue()).map(fn))).toList();
        ImmutableMap mcRooms = ImmutableMap.copyOf(array);
        ars.update((ImmutableMap<Position, Optional<MCRoom>>)mcRooms);
        ars.recheckRecipes(() -> level);
    }

    private static boolean isFence(ServerLevel level, BlockPos bPos) {
        BlockState bs = level.m_8055_(bPos);
        return Ingredient.m_204132_((TagKey)Tags.Items.FENCES).test(new ItemStack((ItemLike)bs.m_60734_().m_5456_(), 1)) || Ingredient.m_204132_((TagKey)Tags.Items.FENCE_GATES).test(new ItemStack((ItemLike)bs.m_60734_().m_5456_(), 1));
    }

    private TownRooms getOrCreateRooms(int scanLevel) {
        Object v;
        if (!this.activeRecipes.containsKey(scanLevel)) {
            v = new ActiveRecipes();
            this.activeRecipes.put(scanLevel, (ActiveRecipes<MCRoom, RoomRecipeMatch<MCRoom>>)v);
            final TownRoomsMap self = this;
            v.addChangeListener((ActiveRecipes.ChangeListener)new ActiveRecipes.ChangeListener<MCRoom, RoomRecipeMatch<MCRoom>>(){

                public void roomRecipeCreated(MCRoom room, RoomRecipeMatch<MCRoom> mcRoomRoomRecipeMatch) {
                    self.recipeListeners.forEach(v -> v.roomRecipeCreated((Object)room, (Object)mcRoomRoomRecipeMatch));
                }

                public void roomRecipeChanged(MCRoom room, RoomRecipeMatch<MCRoom> mcRoomRoomRecipeMatch, MCRoom room1, RoomRecipeMatch<MCRoom> key1) {
                    self.recipeListeners.forEach(v -> v.roomRecipeChanged((Object)room, (Object)mcRoomRoomRecipeMatch, (Object)room1, (Object)key1));
                }

                public void roomRecipeDestroyed(MCRoom room, RoomRecipeMatch<MCRoom> mcRoomRoomRecipeMatch) {
                    self.recipeListeners.forEach(v -> v.roomRecipeDestroyed((Object)room, (Object)mcRoomRoomRecipeMatch));
                }
            });
        }
        if (!this.activeRooms.containsKey(scanLevel)) {
            v = new TownRooms(scanLevel, this::unsafeGetTown);
            this.activeRooms.put(scanLevel, (TownRooms)v);
            ((TownRooms)v).addRecipeRoomChangeListener(this);
        }
        return this.activeRooms.get(scanLevel);
    }

    private TownRooms getOrCreateFarms(int scanLevel) {
        if (!this.activeFarms.containsKey(scanLevel)) {
            TownRooms v = new TownRooms(scanLevel, this::unsafeGetTown){

                @Override
                protected Optional<RoomRecipeMatches<MCRoom>> getActiveRecipes(ServerLevel level, MCRoom room) {
                    Optional active = RecipeDetection.getActiveRecipes((Level)level, (MCRoom)room, (boolean)true);
                    return active.map(v -> v.with(new ResourceLocation[]{SpecialQuests.FARM})).or(() -> Optional.of(TownRoomsMap.this.justFarm(room, level))).map(v -> v);
                }
            };
            v.addRecipeRoomChangeListener(this);
            this.activeFarms.put(scanLevel, v);
        }
        return this.activeFarms.get(scanLevel);
    }

    private RoomRecipeMatches<MCRoom> justFarm(MCRoom room, ServerLevel level) {
        return new RoomRecipeMatches((Object)room, ImmutableList.of((Object)SpecialQuests.FARM), (Iterable)RecipeDetection.getBlocksInRoom((Level)level, (MCRoom)room, (boolean)false).entrySet());
    }

    public void tick(ServerLevel level, BlockPos flagPos) {
        if (this.town == null) {
            throw new IllegalStateException("TownRoomsMap was never initialized");
        }
        if (this.pendingRooms != null) {
            long start = System.currentTimeMillis();
            boolean finished = this.pendingRooms.proceed(this.activeRooms::get);
            if (finished) {
                this.pendingRooms = null;
            }
            this.profileTick("PTR.proceed", start);
            return;
        }
        this.registeredDoors.stream().filter(tp -> {
            BlockPos bp = new BlockPos(tp.x, flagPos.m_123342_() + tp.scanLevel, tp.z);
            BlockState bs = level.m_8055_(bp);
            return !(bs.m_60734_() instanceof DoorBlock) && !(bs.m_60734_() instanceof FalseDoorBlock);
        }).toList().forEach(tp -> this.deRegisterDoor(tp.toPosition(), tp.scanLevel, "not existing anymore"));
        HashMap doorsAtLevel = new HashMap();
        this.registeredDoors.forEach(dp -> doorsAtLevel.computeIfAbsent(dp.scanLevel, k -> new ArrayList()).add(dp.toPosition()));
        this.pendingRooms = new MultiLevelRoomDetector(level, flagPos.m_123342_(), p -> WallDetection.IsWall(level, p.toPosition(), flagPos.m_123342_() + p.scanLevel), p -> WallDetection.IsDoor(level, p.toPosition(), flagPos.m_123342_() + p.scanLevel), (scanLevel, rooms) -> {
            this.getOrCreateRooms((int)scanLevel).update((ImmutableMap<Position, Optional<MCRoom>>)rooms);
            this.registeredDoors.stream().filter(v -> rooms.values().stream().noneMatch(z -> z.isPresent() && v.toPosition().equals((Object)((MCRoom)z.get()).doorPos))).forEach(nonRoomDoor -> this.doorsToDrop.compute(new TownPosition(nonRoomDoor.x, nonRoomDoor.z, (int)scanLevel), (door, ticks) -> ticks == null ? 1 : ticks + 1));
            this.dropDeadDoors(flagPos);
        }, this.activeRecipes::get, (Map<Integer, Collection<Position>>)ImmutableMap.copyOf(doorsAtLevel), false);
        long start = System.currentTimeMillis();
        for (int scanLev : this.registeredFenceGates.stream().map(v -> v.scanLevel).distinct().toList()) {
            Set<Position> gatesAtLevel = this.registeredFenceGates.stream().filter(v -> v.scanLevel == scanLev).map(p -> new Position(p.x, p.z)).collect(Collectors.toSet());
            int y1 = flagPos.m_7918_(0, scanLev, 0).m_123342_();
            this.updateActiveFarms(level, scanLev, y1, gatesAtLevel);
        }
        this.profileTick("queue+farm", start);
    }

    private void dropDeadDoors(BlockPos flagPos) {
        int ticksToKeepNonRoomDoors = 100;
        List<Map.Entry> deadDoors = this.doorsToDrop.entrySet().stream().filter(v -> (Integer)v.getValue() > ticksToKeepNonRoomDoors).toList();
        ImmutableList snapshot = ImmutableList.copyOf(deadDoors);
        snapshot.forEach(entry -> {
            TownPosition deadDoor = (TownPosition)entry.getKey();
            BlockPos p = new BlockPos(deadDoor.x, deadDoor.scanLevel + flagPos.m_123342_(), deadDoor.z);
            String reason = String.format("%d full town scans finished without finding a valid room", this.times.size());
            RoomsHolder.Deregistration dereg = new RoomsHolder.Deregistration(p, reason);
            this.unsafeGetTown().getRoomHandle().deregisterDoor(dereg);
            this.doorsToDrop.remove(new TownPosition(p.m_123341_(), p.m_123343_(), p.m_123342_() - flagPos.m_123342_()));
        });
    }

    private void profileTick(String prefix, long start) {
        if ((Integer)Config.TICK_SAMPLING_RATE.get() == 0) {
            return;
        }
        long end = System.currentTimeMillis();
        this.times.add((int)(end - start));
        if (this.times.size() > (Integer)Config.TICK_SAMPLING_RATE.get()) {
            String msg = "[TownRoomsMap:{}] Average tick length: {} sec";
            OptionalDouble val = this.times.stream().mapToInt(Integer::intValue).average();
            if (val.isPresent() && val.getAsDouble() > 10.0) {
                QT.PROFILE_LOGGER.error(msg, (Object)prefix, (Object)((int)val.getAsDouble()));
            } else if (val.isPresent() && val.getAsDouble() > 1.0) {
                QT.PROFILE_LOGGER.warn(msg, (Object)prefix, (Object)((int)val.getAsDouble()));
            } else {
                QT.PROFILE_LOGGER.debug(msg, (Object)prefix, (Object)val);
            }
            this.times.clear();
        }
    }

    public void initializeNew(TownFlagBlockEntity owner) {
        this.initialize(owner, (ImmutableList<TownPosition>)ImmutableList.of(), (ImmutableList<TownPosition>)ImmutableList.of(), (ImmutableList<TownPosition>)ImmutableList.of());
    }

    public void initialize(TownFlagBlockEntity owner, ImmutableList<TownPosition> registeredDoors, ImmutableList<TownPosition> registeredFenceGates, ImmutableList<TownPosition> doorsWithActiveRecipes) {
        if (!this.activeRecipes.isEmpty()) {
            throw new IllegalStateException("Double initialization");
        }
        ImmutableSet.Builder levelsToInit = ImmutableSet.builder();
        registeredDoors.forEach(p -> levelsToInit.add((Object)p.scanLevel));
        levelsToInit.build().forEach(l -> this.markDoorsForSkipAnnounce((Integer)l, this.getOrCreateRooms((int)l), doorsWithActiveRecipes));
        ImmutableSet.Builder farmLevelsToInit = ImmutableSet.builder();
        registeredDoors.forEach(p -> farmLevelsToInit.add((Object)p.scanLevel));
        farmLevelsToInit.build().forEach(l -> this.markDoorsForSkipAnnounce((Integer)l, this.getOrCreateFarms((int)l), doorsWithActiveRecipes));
        this.activeRecipes.forEach((k, v) -> this.markDoorsForSkipAnnounce((Integer)k, (RoomAnnouncing)v, doorsWithActiveRecipes));
        for (ActiveRecipes<MCRoom, RoomRecipeMatch<MCRoom>> r : this.activeRecipes.values()) {
            r.addChangeListener((ActiveRecipes.ChangeListener)owner);
        }
        this.registeredDoors.addAll((Collection<TownPosition>)registeredDoors);
        this.registeredFenceGates.addAll((Collection<TownPosition>)registeredFenceGates);
        this.town = owner;
    }

    private void markDoorsForSkipAnnounce(Integer scanLevel, RoomAnnouncing recipes, ImmutableList<TownPosition> registeredDoors) {
        List<Position> relevantDoors = registeredDoors.stream().filter(v -> scanLevel.equals(v.scanLevel)).map(TownPosition::toPosition).toList();
        recipes.skipAnnounceOnFirstDetect(relevantDoors);
    }

    @NotNull
    private TownFlagBlockEntity unsafeGetTown() {
        if (this.town == null) {
            throw new IllegalStateException("Town has not been initialized on rooms map yet");
        }
        return this.town;
    }

    public Collection<MCRoom> getAllRooms() {
        return this.activeRooms.values().stream().map(TownRooms::getAll).flatMap(Collection::stream).toList();
    }

    @Override
    public void updateRecipeForRoom(int scanLevel, MCRoom oldRoom, MCRoom newRoom, @Nullable RoomRecipeMatch<MCRoom> resourceLocation) {
        this.getOrCreateRooms(scanLevel);
        this.activeRecipes.get(scanLevel).update((Room)oldRoom, (Room)newRoom, resourceLocation);
    }

    public int numRecipes() {
        return this.activeRecipes.size();
    }

    public Collection<RoomRecipeMatch<MCRoom>> getAllMatches(Predicate<RoomRecipeMatch<MCRoom>> include) {
        Stream<RoomRecipeMatch<MCRoom>> objectStream = this.activeRecipes.values().stream().map(ActiveRecipes::entrySet).flatMap(v -> v.stream().map(Map.Entry::getValue)).filter(include);
        return objectStream.collect(Collectors.toSet());
    }

    public void registerDoor(Position p, int scanLevel) {
        this.registeredDoors.add(new TownPosition(p.x, p.z, scanLevel));
        Questown.LOGGER.debug("Door was registered at x={}, z={}, scanLevel={}", (Object)p.x, (Object)p.z, (Object)scanLevel);
    }

    public void deRegisterDoor(Position p, int scanLevel, String reason) {
        this.registeredDoors.remove(new TownPosition(p.x, p.z, scanLevel));
        Questown.LOGGER.debug("Door was de-registered at x={}, z={}, scanLevel={}, reason={}", (Object)p.x, (Object)p.z, (Object)scanLevel, (Object)reason);
        TownRooms rooms = this.getOrCreateRooms(scanLevel);
        Optional<MCRoom> oldRoom = rooms.get(p);
        oldRoom.ifPresent(mcRoom -> rooms.roomDestroyed(p, (MCRoom)mcRoom));
    }

    public void registerFenceGate(Position p, int scanLevel) {
        this.registeredFenceGates.add(new TownPosition(p.x, p.z, scanLevel));
        Questown.LOGGER.debug("Fence gate was registered at x={}, z={}, scanLevel={}", (Object)p.x, (Object)p.z, (Object)scanLevel);
    }

    public Collection<RoomRecipeMatch<MCRoom>> getRoomsMatching(ResourceLocation recipeId) {
        ImmutableList.Builder b = ImmutableList.builder();
        List all = Stream.concat(this.registeredDoors.stream(), this.registeredFenceGates.stream()).toList();
        for (TownPosition p : all) {
            Position pz = new Position(p.x, p.z);
            TownRooms rooms = this.getOrCreateRooms(p.scanLevel);
            Optional<MCRoom> room = rooms.getAll().stream().filter(v -> v.getDoorPos().equals((Object)pz)).findFirst();
            if (room.isEmpty() && (room = (rooms = this.getOrCreateFarms(p.scanLevel)).getAll().stream().filter(v -> v.getDoorPos().equals((Object)pz)).findFirst()).isEmpty()) continue;
            ActiveRecipes<MCRoom, RoomRecipeMatch<MCRoom>> recipes = this.activeRecipes.get(p.scanLevel);
            for (Map.Entry m : recipes.entrySet()) {
                for (ResourceLocation mRecipeId : ((RoomRecipeMatch)m.getValue()).getRecipeIDs()) {
                    if (!((MCRoom)m.getKey()).equals((Object)room.get()) || !mRecipeId.equals((Object)recipeId)) continue;
                    b.add((Object)((RoomRecipeMatch)m.getValue()));
                }
            }
        }
        return b.build();
    }

    public Collection<MCRoom> getFarms() {
        return this.activeFarms.entrySet().stream().flatMap(v -> ((TownRooms)v.getValue()).getAll().stream()).toList();
    }

    public boolean isDoorRegistered(Position position, int y) {
        return this.registeredDoors.stream().anyMatch(v -> v.scanLevel == y && position.x == v.x && position.z == v.z);
    }

    public Optional<RoomRecipeMatches<MCRoom>> computeRecipe(ServerLevel serverLevel, MCRoom r) {
        return RecipeDetection.getActiveRecipes((Level)serverLevel, (MCRoom)r, (boolean)false);
    }

    public ImmutableSet<TownPosition> getAllRegisteredDoors() {
        return ImmutableSet.copyOf(this.registeredDoors);
    }

    public void addRecipeListener(ActiveRecipes.ChangeListener<MCRoom, RoomRecipeMatch<MCRoom>> l) {
        this.recipeListeners.add(l);
    }

    public ImmutableSet<BlockPos> getAllActiveRecipeDoors() {
        ImmutableSet.Builder b = ImmutableSet.builder();
        this.activeRecipes.forEach((k, v) -> v.entrySet().forEach(v2 -> b.add((Object)Positions.ToBlock((Position)((MCRoom)v2.getKey()).doorPos, (int)((MCRoom)v2.getKey()).yCoord))));
        this.activeFarms.forEach((k, v) -> v.getAll().forEach(v2 -> b.add((Object)Positions.ToBlock((Position)v2.doorPos, (int)(v2.yCoord + 1)))));
        return b.build();
    }
}

