/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.rooms;

import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.town.TownFlagBlockEntity;
import ca.bradj.questown.town.rooms.TownPosition;
import ca.bradj.questown.town.rooms.TownRoomsMap;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class TownRoomsMapSerializer {
    public static final TownRoomsMapSerializer INSTANCE = new TownRoomsMapSerializer();
    private static final String NBT_REGISTERED_DOORS = String.format("%s_registered_doors", "questown");
    private static final String NBT_REGISTERED_FENCE_GATES = String.format("%s_registered_fence_gates", "questown");
    private static final String NBT_DOORS_WITH_ACTIVE_RECIPES = String.format("%s_doors_with_active_recipes", "questown");
    private static final String NBT_POS_X = "position_x";
    private static final String NBT_POS_Y = "position_y";
    private static final String NBT_POS_Z = "position_z";

    public void deserialize(CompoundTag tag, TownFlagBlockEntity owner, TownRoomsMap roomsMap) {
        ImmutableList.Builder doorsB = ImmutableList.builder();
        if (tag.m_128441_(NBT_REGISTERED_DOORS)) {
            ListTag doors = tag.m_128437_(NBT_REGISTERED_DOORS, 10);
            for (Iterator t : doors) {
                CompoundTag ct = (CompoundTag)t;
                int x = ct.m_128451_(NBT_POS_X);
                int y = ct.m_128451_(NBT_POS_Y);
                int z = ct.m_128451_(NBT_POS_Z);
                doorsB.add((Object)new TownPosition(x, z, y));
            }
        }
        ImmutableList.Builder gatesB = ImmutableList.builder();
        if (tag.m_128441_(NBT_REGISTERED_FENCE_GATES)) {
            ListTag gates = tag.m_128437_(NBT_REGISTERED_FENCE_GATES, 10);
            for (Tag t : gates) {
                CompoundTag ct = (CompoundTag)t;
                int x = ct.m_128451_(NBT_POS_X);
                int y = ct.m_128451_(NBT_POS_Y);
                int z = ct.m_128451_(NBT_POS_Z);
                gatesB.add((Object)new TownPosition(x, z, y));
            }
        }
        ImmutableList.Builder doorsWithRecipes = ImmutableList.builder();
        if (tag.m_128441_(NBT_DOORS_WITH_ACTIVE_RECIPES)) {
            ListTag gates = tag.m_128437_(NBT_DOORS_WITH_ACTIVE_RECIPES, 10);
            for (Tag t : gates) {
                CompoundTag ct = (CompoundTag)t;
                int x = ct.m_128451_(NBT_POS_X);
                int y = ct.m_128451_(NBT_POS_Y);
                int z = ct.m_128451_(NBT_POS_Z);
                doorsWithRecipes.add((Object)Compat.townPos(owner.getTownFlagBasePos(), new BlockPos(x, y, z)));
            }
        }
        roomsMap.initialize(owner, (ImmutableList<TownPosition>)doorsB.build(), (ImmutableList<TownPosition>)gatesB.build(), (ImmutableList<TownPosition>)doorsWithRecipes.build());
    }

    public CompoundTag serializeNBT(TownRoomsMap roomsMap) {
        CompoundTag tag = new CompoundTag();
        ListTag doors = new ListTag();
        for (TownPosition townPosition : roomsMap.getRegisteredDoors()) {
            CompoundTag bpt = new CompoundTag();
            bpt.m_128405_(NBT_POS_X, townPosition.x);
            bpt.m_128405_(NBT_POS_Y, townPosition.scanLevel);
            bpt.m_128405_(NBT_POS_Z, townPosition.z);
            doors.add((Object)bpt);
        }
        tag.m_128365_(NBT_REGISTERED_DOORS, (Tag)doors);
        ListTag gates = new ListTag();
        for (TownPosition bp : roomsMap.getRegisteredGates()) {
            CompoundTag bpt = new CompoundTag();
            bpt.m_128405_(NBT_POS_X, bp.x);
            bpt.m_128405_(NBT_POS_Y, bp.scanLevel);
            bpt.m_128405_(NBT_POS_Z, bp.z);
            gates.add((Object)bpt);
        }
        tag.m_128365_(NBT_REGISTERED_FENCE_GATES, (Tag)gates);
        ListTag listTag = new ListTag();
        for (BlockPos bp : roomsMap.getAllActiveRecipeDoors()) {
            CompoundTag t = new CompoundTag();
            t.m_128405_(NBT_POS_X, bp.m_123341_());
            t.m_128405_(NBT_POS_Y, bp.m_123342_());
            t.m_128405_(NBT_POS_Z, bp.m_123343_());
            listTag.add((Object)t);
        }
        tag.m_128365_(NBT_DOORS_WITH_ACTIVE_RECIPES, (Tag)listTag);
        return tag;
    }
}

