/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.special;

import ca.bradj.questown.Questown;
import ca.bradj.questown.blocks.PlateBlock;
import ca.bradj.questown.blocks.WelcomeMatBlock;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.jobs.WorkLocation;
import ca.bradj.roomrecipes.recipes.RoomRecipe;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class SpecialQuests {
    public static final ResourceLocation CAMPFIRE = new ResourceLocation("questown", "special_quest.campfire");
    public static final ResourceLocation BROKEN = new ResourceLocation("questown", "special_quest.broken");
    public static final ResourceLocation TOWN_GATE = new ResourceLocation("questown", "special_quest.town_gate");
    public static final ResourceLocation TOWN_FLAG = new ResourceLocation("questown", "special_quest.town_flag");
    public static final ResourceLocation FARM = new ResourceLocation("questown", "special_quest.farm");
    public static final Map<ResourceLocation, RoomRecipe> SPECIAL_QUESTS = ImmutableMap.of((Object)BROKEN, (Object)new RoomRecipe(BROKEN, NonNullList.m_122779_(), Integer.MAX_VALUE, false), (Object)CAMPFIRE, (Object)new RoomRecipe(CAMPFIRE, NonNullList.m_122780_((int)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42781_})), Integer.MAX_VALUE, false), (Object)TOWN_GATE, (Object)new RoomRecipe(TOWN_GATE, NonNullList.m_122780_((int)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsInit.WELCOME_MAT_BLOCK.get()})), Integer.MAX_VALUE, false), (Object)TOWN_FLAG, (Object)new RoomRecipe(TOWN_FLAG, NonNullList.m_122780_((int)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsInit.TOWN_FLAG_BLOCK.get()})), Integer.MAX_VALUE, false), (Object)FARM, (Object)new RoomRecipe(FARM, NonNullList.m_122780_((int)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42329_})), Integer.MAX_VALUE, true));
    public static final ResourceLocation BEDROOM = Questown.ResourceLocation("bedroom");
    public static final ResourceLocation JOB_BOARD = Questown.ResourceLocation("job_board");
    public static final ResourceLocation DINING_ROOM = Questown.ResourceLocation("dining_room");
    public static final ResourceLocation CLINIC = Questown.ResourceLocation("clinic");
    public static final WorkLocation TOWN_GATE_LOCATION = new WorkLocation(ctx -> SpecialQuests.isWelcomeMat(ctx.blockInfo(), ctx.blockPos()), SpecialQuests::isWelcomeMat, TOWN_GATE);
    public static final WorkLocation DINING_ROOM_LOCATION = new WorkLocation(ctx -> WorkLocation.isBlock(PlateBlock.class).test(ctx.blockInfo(), ctx.blockPos()), (info, pos) -> WorkLocation.isBlock(PlateBlock.class).test((WorkLocation.BlockInfo)info, (BlockPos)pos), DINING_ROOM);

    public static boolean isSpecialQuest(ResourceLocation id) {
        return SPECIAL_QUESTS.containsKey(id);
    }

    public static boolean isWelcomeMat(WorkLocation.BlockInfo info, BlockPos pos) {
        return WorkLocation.isBlock(WelcomeMatBlock.class).test(info, pos);
    }
}

