/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.workstatus;

import java.util.Objects;

public class State {
    private final int processingState;
    private final int ingredientCount;
    private final int workLeft;

    private State(int processingState, int ingredientCounts, int workLeft) {
        this.processingState = processingState;
        this.ingredientCount = ingredientCounts;
        this.workLeft = workLeft;
    }

    public static State fresh() {
        return new State(0, 0, 0);
    }

    public static State freshAtState(int s) {
        return new State(s, 0, 0);
    }

    public State setProcessing(int s) {
        return new State(s, this.ingredientCount, this.workLeft);
    }

    public State setWorkLeft(int newVal) {
        return new State(this.processingState, this.ingredientCount, newVal * 10);
    }

    private State internalSetWorkLeft(int newVal) {
        return new State(this.processingState, this.ingredientCount, newVal);
    }

    public State setCount(int count) {
        return new State(this.processingState, count, this.workLeft);
    }

    public String toString() {
        return "State{processingState=" + this.processingState + ", ingredientCount=" + this.ingredientCount + ", workLeft=" + 0.1f * (float)this.workLeft + "}";
    }

    public String toShortString() {
        return "[state=" + this.processingState + ", ingCount=" + this.ingredientCount + ", workLeft=" + 0.1f * (float)this.workLeft + "]";
    }

    public State incrProcessing() {
        return this.setProcessing(this.processingState + 1);
    }

    public State incrIngredientCount() {
        return this.setCount(this.ingredientCount + 1);
    }

    public State decrWork(int amountOf10) {
        if (amountOf10 > 10 || amountOf10 < 1) {
            throw new IllegalArgumentException("Only 1-10 are allowed (got: " + amountOf10 + ")");
        }
        return this.internalSetWorkLeft(Math.max(this.workLeft - amountOf10, 0));
    }

    public boolean isFresh() {
        return State.fresh().equals(this);
    }

    public int processingState() {
        return this.processingState;
    }

    public int workLeft() {
        return (int)Math.ceil(0.1f * (float)this.workLeft);
    }

    public boolean hasWorkLeft() {
        return (double)this.workLeft > 0.0;
    }

    public int ingredientCount() {
        return this.ingredientCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        State state = (State)o;
        return this.processingState == state.processingState && this.ingredientCount == state.ingredientCount && this.workLeft == state.workLeft;
    }

    public int hashCode() {
        return Objects.hash(this.processingState, this.ingredientCount, this.workLeft);
    }
}

