/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown._vanilla;

import ca.bradj.questown.InventoryFullStrategy;
import ca.bradj.questown.integration.jobs.BeforeExtractEvent;
import ca.bradj.questown.integration.jobs.BeforeTickEvent;
import ca.bradj.questown.integration.jobs.JobPhaseModifier;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.mobs.visitor.ItemAcceptor;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ChopDownTree
extends JobPhaseModifier {
    @Override
    @Nullable
    public <CONTEXT> CONTEXT beforeExtract(CONTEXT ctxInput, BeforeExtractEvent<CONTEXT> event) {
        CONTEXT context = super.beforeExtract(ctxInput, event);
        BlockPos treeTrunk = event.workSpot();
        ServerLevel level = event.level();
        Block b = level.m_8055_(treeTrunk).m_60734_();
        return this.removeBlock(context, level, treeTrunk, event.entity(), b);
    }

    private <CONTEXT> CONTEXT removeBlock(CONTEXT ctxInput, ServerLevel level, BlockPos treeTrunk, ItemAcceptor<CONTEXT> entity, Block block) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)treeTrunk.m_7918_(-1, 0, -1), (BlockPos)treeTrunk.m_7918_(1, 1, 1))) {
            BlockState bs = level.m_8055_(pos);
            if (!bs.m_60713_(block)) continue;
            level.m_7471_(pos, true);
            MCHeldItem i = MCHeldItem.fromTown(block.m_5456_());
            ctxInput = entity.tryGiveItem(ctxInput, i, InventoryFullStrategy.REMOVE_FROM_WORLD);
            this.removeBlock(ctxInput, level, pos, entity, bs.m_60734_());
        }
        return ctxInput;
    }

    @Override
    public void beforeTick(BeforeTickEvent bxEvent) {
        super.beforeTick(bxEvent);
    }
}

