/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown._vanilla;

import ca.bradj.questown._vanilla.entities.EntitiesInit;
import ca.bradj.questown._vanilla.entities.FishingHook;
import ca.bradj.questown.blocks.FishingStationBlock;
import ca.bradj.questown.integration.jobs.AfterInsertItemEvent;
import ca.bradj.questown.integration.jobs.BeforeExtractEvent;
import ca.bradj.questown.integration.jobs.JobPhaseModifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DeployFishingHookRule
extends JobPhaseModifier {
    private List<Entity> hooks = new ArrayList<Entity>();

    @Nullable
    public static FishingHook deployHere(ServerLevel sl, BlockPos blockPos, LivingEntity owner) {
        FishingHook e = (FishingHook)((EntityType)EntitiesInit.FISHIN_HOOK.get()).m_20615_((Level)sl);
        if (e == null) {
            return null;
        }
        Vec3 attachPoint = Vec3.m_82528_((Vec3i)blockPos.m_7494_());
        Vec3 rodTip = FishingStationBlock.getAttachPoint(blockPos, sl);
        Vec3 hookPos = Vec3.m_82539_((Vec3i)blockPos);
        if (rodTip != null) {
            attachPoint = rodTip;
            hookPos = FishingStationBlock.getRandomHookPos(blockPos, sl);
        }
        e.setOwner(owner, attachPoint);
        if (hookPos == null) {
            Vec3 push = Vec3.m_82512_((Vec3i)blockPos);
            push = push.m_82546_(Vec3.m_82512_((Vec3i)owner.m_20183_()));
            push = push.m_82541_();
            push = push.m_82542_(3.0, 1.0, 3.0);
            hookPos = Vec3.m_82539_((Vec3i)blockPos.m_7637_(push.f_82479_, 0.0, push.f_82481_));
        }
        e.m_146884_(hookPos);
        sl.m_7967_((Entity)e);
        return e;
    }

    @Override
    @Nullable
    public <CONTEXT> CONTEXT afterInsertItem(CONTEXT ctxInput, AfterInsertItemEvent<CONTEXT> event) {
        CONTEXT ctx = super.afterInsertItem(ctxInput, event);
        LivingEntity villager = (LivingEntity)event.level().m_8791_(event.inserter());
        @Nullable FishingHook deployed = DeployFishingHookRule.deployHere(event.level(), event.workSpot().workPosition(), villager);
        if (deployed != null) {
            this.hooks.add((Entity)deployed);
        }
        return ctx;
    }

    @Override
    @Nullable
    public <CONTEXT> CONTEXT beforeExtract(CONTEXT ctxInput, BeforeExtractEvent<CONTEXT> event) {
        CONTEXT context = super.beforeExtract(ctxInput, event);
        this.hooks.forEach(h -> h.m_142687_(Entity.RemovalReason.DISCARDED));
        return context;
    }
}

