/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.blocks;

import ca.bradj.questown.blocks.InsertedItemAware;
import ca.bradj.questown.blocks.entity.AxeRackBlockEntity;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.core.network.SyncBlockItemMessage;
import ca.bradj.questown.integration.minecraft.MCContainerInterface;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.jobs.Containers;
import ca.bradj.questown.jobs.declarative.MCExtra;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class AxeRackBlock
extends Block
implements InsertedItemAware,
EntityBlock {
    public static final String ITEM_ID = "axe_rack_block";
    public static final int MAX = 1;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0);

    public AxeRackBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60913_(1.0f, 10.0f).m_60955_());
        this.m_49959_((BlockState)this.f_49792_.m_61090_());
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.m_49966_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51385_) {
    }

    public void m_6810_(BlockState p_51538_, Level p_51539_, BlockPos pos, BlockState p_51541_, boolean p_51542_) {
        if (!p_51538_.m_60713_(p_51541_.m_60734_())) {
            BlockEntity blockentity = p_51539_.m_7702_(pos);
            if (blockentity instanceof AxeRackBlockEntity) {
                AxeRackBlockEntity fde = (AxeRackBlockEntity)blockentity;
                if (p_51539_ instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)p_51539_;
                    AxeRackBlock.dropAllLoot(pos, fde, sl);
                }
                p_51539_.m_46717_(pos, (Block)this);
            }
            super.m_6810_(p_51538_, p_51539_, pos, p_51541_, p_51542_);
        }
    }

    private static void dropAllLoot(BlockPos pos, MCContainerInterface fde, ServerLevel sl) {
        for (int i = 0; i < fde.size(); ++i) {
            MCTownItem m = (MCTownItem)fde.getItem(i);
            if (m.isEmpty()) continue;
            sl.m_7967_((Entity)new ItemEntity((Level)sl, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), m.toMCItemStack()));
        }
        ItemStack item = ((Item)ItemsInit.AXE_RACK_BLOCK.get()).m_7968_();
        sl.m_7967_((Entity)new ItemEntity((Level)sl, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), item));
    }

    @Override
    public void handleInsertedItem(MCExtra extra, BlockPos bp, MCHeldItem item) {
        BlockEntity e = extra.town().getServerLevel().m_7702_(bp);
        if (!(e instanceof AxeRackBlockEntity)) {
            return;
        }
        AxeRackBlockEntity rack = (AxeRackBlockEntity)e;
        rack.addItem(item);
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level level, BlockPos p_60505_, Player p_60506_, InteractionHand hand, BlockHitResult p_60508_) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.CONSUME;
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.CONSUME;
        }
        ServerLevel sl = (ServerLevel)level;
        BlockEntity entity = sl.m_7702_(p_60505_);
        if (!(entity instanceof AxeRackBlockEntity)) {
            return InteractionResult.CONSUME;
        }
        AxeRackBlockEntity rack = (AxeRackBlockEntity)entity;
        ItemStack itemInHand = p_60506_.m_21120_(hand);
        if (itemInHand.m_41619_()) {
            return this.take(rack, p_60506_);
        }
        if (rack.isFull()) {
            return InteractionResult.CONSUME;
        }
        ItemStack copy = itemInHand.m_41777_();
        int index = Containers.addIfPossible(itemInHand, rack);
        if (index >= 0) {
            QuestownNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncBlockItemMessage(p_60505_, copy, index));
        }
        return InteractionResult.CONSUME;
    }

    private InteractionResult take(AxeRackBlockEntity entity, Player p_60506_) {
        for (int i = 0; i < entity.size(); ++i) {
            MCTownItem item = entity.getItem(i);
            if (item == null || item.isEmpty()) continue;
            ItemStack stack = item.toQTItemStack();
            p_60506_.m_21008_(InteractionHand.MAIN_HAND, stack);
            entity.removeItem(i);
            QuestownNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncBlockItemMessage(entity.m_58899_(), ItemStack.f_41583_, i));
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new AxeRackBlockEntity(blockPos, blockState);
    }

    public RenderShape m_7514_(BlockState p_60550_) {
        return RenderShape.MODEL;
    }
}

