/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.blocks;

import ca.bradj.questown._vanilla.DeployFishingHookRule;
import ca.bradj.questown.blocks.RoomBlock;
import ca.bradj.questown.mc.Compat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FishingStationBlock
extends RoomBlock {
    public static final String ITEM_ID = "fishing_station";

    public FishingStationBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60913_(1.0f, 10.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH));
    }

    public static Vec3 getRandomHookPos(BlockPos blockPos, ServerLevel sl) {
        BlockPos relative;
        int i;
        BlockState blockState = sl.m_8055_(blockPos);
        if (!(blockState.m_60734_() instanceof FishingStationBlock)) {
            return null;
        }
        Direction facing = ((Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
        for (i = 0; i < 20; ++i) {
            relative = blockPos.m_5484_(facing, Compat.nextRandomInt(sl, 5));
            relative = relative.m_5484_(facing.m_122427_(), Compat.nextRandomInt(sl, 5) - 2);
            relative = sl.m_5452_(Heightmap.Types.WORLD_SURFACE, relative);
            BlockState below = sl.m_8055_(relative.m_7495_());
            BlockState above = sl.m_8055_(relative);
            if (!below.m_60713_(Blocks.f_49990_) || !above.m_60795_()) continue;
            return Vec3.m_82539_((Vec3i)relative);
        }
        for (i = 1; i <= 5; ++i) {
            relative = blockPos.m_5484_(facing, i);
            for (int j = -2; j <= 2; ++j) {
                BlockPos checkPos = relative.m_5484_(facing.m_122427_(), j);
                checkPos = sl.m_5452_(Heightmap.Types.WORLD_SURFACE, checkPos);
                BlockState below = sl.m_8055_(checkPos.m_7495_());
                BlockState above = sl.m_8055_(checkPos);
                if (!below.m_60713_(Blocks.f_49990_) || !above.m_60795_()) continue;
                return Vec3.m_82539_((Vec3i)checkPos);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        @Nullable BlockState blockState = super.m_5573_(ctx);
        blockState = (BlockState)blockState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)ctx.m_8125_().m_122424_());
        return blockState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51385_) {
        p_51385_.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_});
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player p_60506_, InteractionHand p_60507_, BlockHitResult p_60508_) {
        if (p_60507_ != InteractionHand.MAIN_HAND) {
            return super.m_6227_(p_60503_, p_60504_, p_60505_, p_60506_, p_60507_, p_60508_);
        }
        if (!(p_60504_ instanceof ServerLevel)) {
            return super.m_6227_(p_60503_, p_60504_, p_60505_, p_60506_, p_60507_, p_60508_);
        }
        ServerLevel sl = (ServerLevel)p_60504_;
        if (DeployFishingHookRule.deployHere(sl, p_60505_, (LivingEntity)p_60506_) != null) {
            return super.m_6227_(p_60503_, p_60504_, p_60505_, p_60506_, p_60507_, p_60508_);
        }
        return InteractionResult.CONSUME;
    }

    public static Vec3 getAttachPoint(BlockPos p_60505_, ServerLevel sl) {
        BlockState bs = sl.m_8055_(p_60505_);
        Direction v = ((Direction)bs.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
        Vec3 b = Vec3.m_82539_((Vec3i)p_60505_);
        Vec3 tip = Compat.relative(b.m_82520_(0.0, 1.0, 0.0), v, 0.5);
        int r = sl.m_213780_().m_188503_(3);
        if (r == 0) {
            tip = Compat.relative(tip, v.m_122427_(), 0.1);
        } else if (r == 1) {
            tip = Compat.relative(tip, v.m_122428_(), 0.1);
        }
        return tip;
    }

    @Override
    public String getId() {
        return ITEM_ID;
    }
}

