/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.blocks;

import ca.bradj.questown.QT;
import ca.bradj.questown.blocks.Healing;
import ca.bradj.questown.blocks.TownFlagBlock;
import ca.bradj.questown.blocks.entity.HospitalBedBlockEntity;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.extensions.IForgeBlock;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class HospitalBedBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
Healing,
IForgeBlock {
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    public static final String ITEM_ID = "hospital_bed";
    protected static final int HEIGHT = 9;
    protected static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private static final int LEG_WIDTH = 3;
    protected static final VoxelShape LEG_NORTH_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0);
    protected static final VoxelShape LEG_SOUTH_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0);
    protected static final VoxelShape LEG_NORTH_EAST = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0);
    protected static final VoxelShape LEG_SOUTH_EAST = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_WEST, LEG_NORTH_EAST});
    protected static final VoxelShape SOUTH_SHAPE = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_SOUTH_WEST, LEG_SOUTH_EAST});
    protected static final VoxelShape WEST_SHAPE = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_WEST, LEG_SOUTH_WEST});
    protected static final VoxelShape EAST_SHAPE = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_EAST, LEG_SOUTH_EAST});
    private final DyeColor color;

    public HospitalBedBlock() {
        this(DyeColor.BLACK, BlockBehaviour.Properties.m_60947_((Material)Material.f_76272_, p_152613_ -> p_152613_.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT ? DyeColor.BLACK.m_41069_() : MaterialColor.f_76401_).m_60918_(SoundType.f_56736_).m_60978_(0.2f).m_60955_());
    }

    public HospitalBedBlock(DyeColor p_49454_, BlockBehaviour.Properties p_49455_) {
        super(p_49455_);
        this.color = p_49454_;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61391_, (Comparable)BedPart.FOOT)).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    @javax.annotation.Nullable
    public static Direction getBedOrientation(BlockGetter p_49486_, BlockPos p_49487_) {
        BlockState blockstate = p_49486_.m_8055_(p_49487_);
        return blockstate.m_60734_() instanceof BedBlock ? (Direction)blockstate.m_61143_((Property)f_54117_) : null;
    }

    public InteractionResult m_6227_(BlockState p_49515_, Level p_49516_, BlockPos p_49517_, Player p_49518_, InteractionHand p_49519_, BlockHitResult p_49520_) {
        if (p_49516_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (p_49515_.m_61143_((Property)BlockStateProperties.f_61391_) != BedPart.HEAD && !(p_49515_ = p_49516_.m_8055_(p_49517_ = p_49517_.m_121945_((Direction)p_49515_.m_61143_((Property)f_54117_)))).m_60713_((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!HospitalBedBlock.canSetSpawn(p_49516_)) {
            p_49516_.m_7471_(p_49517_, false);
            BlockPos blockpos = p_49517_.m_121945_(((Direction)p_49515_.m_61143_((Property)f_54117_)).m_122424_());
            if (p_49516_.m_8055_(blockpos).m_60713_((Block)this)) {
                p_49516_.m_7471_(blockpos, false);
            }
            p_49516_.m_7703_((Entity)null, DamageSource.m_19334_(), (ExplosionDamageCalculator)null, (double)p_49517_.m_123341_() + 0.5, (double)p_49517_.m_123342_() + 0.5, (double)p_49517_.m_123343_() + 0.5, 5.0f, true, Explosion.BlockInteraction.DESTROY);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)p_49515_.m_61143_((Property)OCCUPIED)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(p_49516_, p_49517_)) {
                p_49518_.m_5661_(Compat.translatable("block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        p_49518_.m_7720_(p_49517_).ifLeft(p_49477_ -> {
            if (p_49477_ != null) {
                p_49518_.m_5661_(p_49477_.m_36423_(), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    public static boolean canSetSpawn(Level p_49489_) {
        return p_49489_.m_6042_().f_63862_();
    }

    private boolean kickVillagerOutOfBed(Level p_49491_, BlockPos p_49492_) {
        List list = p_49491_.m_6443_(Villager.class, new AABB(p_49492_), LivingEntity::m_5803_);
        if (list.isEmpty()) {
            return false;
        }
        ((Villager)list.get(0)).m_5796_();
        return true;
    }

    public void m_142072_(Level p_152169_, BlockState p_152170_, BlockPos p_152171_, Entity p_152172_, float p_152173_) {
        super.m_142072_(p_152169_, p_152170_, p_152171_, p_152172_, p_152173_ * 0.5f);
    }

    public void m_5548_(BlockGetter p_49483_, Entity p_49484_) {
        if (p_49484_.m_20162_()) {
            super.m_5548_(p_49483_, p_49484_);
        } else {
            this.bounceUp(p_49484_);
        }
    }

    private void bounceUp(Entity p_49457_) {
        Vec3 vec3 = p_49457_.m_20184_();
        if (vec3.f_82480_ < 0.0) {
            double d0 = p_49457_ instanceof LivingEntity ? 1.0 : 0.8;
            p_49457_.m_20334_(vec3.f_82479_, -vec3.f_82480_ * (double)0.66f * d0, vec3.f_82481_);
        }
    }

    public BlockState m_7417_(BlockState p_49525_, Direction p_49526_, BlockState p_49527_, LevelAccessor p_49528_, BlockPos p_49529_, BlockPos p_49530_) {
        if (p_49526_ == HospitalBedBlock.getNeighbourDirection((BedPart)p_49525_.m_61143_((Property)BlockStateProperties.f_61391_), (Direction)p_49525_.m_61143_((Property)f_54117_))) {
            return p_49527_.m_60713_((Block)this) && p_49527_.m_61143_((Property)BlockStateProperties.f_61391_) != p_49525_.m_61143_((Property)BlockStateProperties.f_61391_) ? (BlockState)p_49525_.m_61124_((Property)OCCUPIED, (Comparable)((Boolean)p_49527_.m_61143_((Property)OCCUPIED))) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(p_49525_, p_49526_, p_49527_, p_49528_, p_49529_, p_49530_);
    }

    private static Direction getNeighbourDirection(BedPart p_49534_, Direction p_49535_) {
        return p_49534_ == BedPart.FOOT ? p_49535_ : p_49535_.m_122424_();
    }

    public void m_5707_(Level p_49505_, BlockPos p_49506_, BlockState p_49507_, Player p_49508_) {
        BlockPos blockpos;
        BlockState blockstate;
        BedPart bedpart;
        if (!p_49505_.f_46443_ && p_49508_.m_7500_() && (bedpart = (BedPart)p_49507_.m_61143_((Property)BlockStateProperties.f_61391_)) == BedPart.FOOT && (blockstate = p_49505_.m_8055_(blockpos = p_49506_.m_121945_(HospitalBedBlock.getNeighbourDirection(bedpart, (Direction)p_49507_.m_61143_((Property)f_54117_))))).m_60713_((Block)this) && blockstate.m_61143_((Property)BlockStateProperties.f_61391_) == BedPart.HEAD) {
            p_49505_.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            p_49505_.m_5898_(p_49508_, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
        super.m_5707_(p_49505_, p_49506_, p_49507_, p_49508_);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState;
        Direction direction = ctx.m_8125_();
        BlockPos blockpos = ctx.m_8083_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        Level level = ctx.m_43725_();
        BlockState blockState2 = blockState = level.m_8055_(blockpos1).m_60629_(ctx) && level.m_6857_().m_61937_(blockpos1) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
        if (!(level instanceof ServerLevel)) {
            return blockState;
        }
        ServerLevel sl = (ServerLevel)level;
        ItemStack item = ctx.m_43722_();
        @Nullable TownFlagBlockEntity parent = TownFlagBlock.GetParentFromNBT(sl, item);
        BlockPos matPos = ctx.m_8083_();
        if (parent == null) {
            QT.BLOCK_LOGGER.error("Hospital bed is not associated to an existing flag", new Object[0]);
            sl.m_7967_((Entity)new ItemEntity((Level)sl, (double)matPos.m_123341_(), (double)matPos.m_123342_(), (double)matPos.m_123343_(), ctx.m_43722_()));
            return Blocks.f_50016_.m_49966_();
        }
        parent.getHealingHandle().registerHealingBed(blockpos, blockpos1, (Double)Config.HOSPITAL_BED_HEAL_MULTIPLIER.get());
        return blockState;
    }

    public VoxelShape m_5940_(BlockState p_49547_, BlockGetter p_49548_, BlockPos p_49549_, CollisionContext p_49550_) {
        Direction direction = HospitalBedBlock.getConnectedDirection(p_49547_).m_122424_();
        switch (direction) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return EAST_SHAPE;
    }

    public static Direction getConnectedDirection(BlockState p_49558_) {
        Direction direction = (Direction)p_49558_.m_61143_((Property)f_54117_);
        return p_49558_.m_61143_((Property)BlockStateProperties.f_61391_) == BedPart.HEAD ? direction.m_122424_() : direction;
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState p_49560_) {
        BedPart bedpart = (BedPart)p_49560_.m_61143_((Property)BlockStateProperties.f_61391_);
        return bedpart == BedPart.HEAD ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    private static boolean isBunkBed(BlockGetter p_49542_, BlockPos p_49543_) {
        return p_49542_.m_8055_(p_49543_.m_7495_()).m_60734_() instanceof BedBlock;
    }

    public static Optional<Vec3> findStandUpPosition(EntityType<?> p_49459_, CollisionGetter p_49460_, BlockPos p_49461_, float p_49462_) {
        Direction direction2;
        Direction direction = (Direction)p_49460_.m_8055_(p_49461_).m_61143_((Property)f_54117_);
        Direction direction1 = direction.m_122427_();
        Direction direction3 = direction2 = direction1.m_122370_(p_49462_) ? direction1.m_122424_() : direction1;
        if (HospitalBedBlock.isBunkBed((BlockGetter)p_49460_, p_49461_)) {
            return HospitalBedBlock.findBunkBedStandUpPosition(p_49459_, p_49460_, p_49461_, direction, direction2);
        }
        int[][] aint = HospitalBedBlock.bedStandUpOffsets(direction, direction2);
        Optional<Vec3> optional = HospitalBedBlock.findStandUpPositionAtOffset(p_49459_, p_49460_, p_49461_, aint, true);
        return optional.isPresent() ? optional : HospitalBedBlock.findStandUpPositionAtOffset(p_49459_, p_49460_, p_49461_, aint, false);
    }

    private static Optional<Vec3> findBunkBedStandUpPosition(EntityType<?> p_49464_, CollisionGetter p_49465_, BlockPos p_49466_, Direction p_49467_, Direction p_49468_) {
        int[][] aint = HospitalBedBlock.bedSurroundStandUpOffsets(p_49467_, p_49468_);
        Optional<Vec3> optional = HospitalBedBlock.findStandUpPositionAtOffset(p_49464_, p_49465_, p_49466_, aint, true);
        if (optional.isPresent()) {
            return optional;
        }
        BlockPos blockpos = p_49466_.m_7495_();
        Optional<Vec3> optional1 = HospitalBedBlock.findStandUpPositionAtOffset(p_49464_, p_49465_, blockpos, aint, true);
        if (optional1.isPresent()) {
            return optional1;
        }
        int[][] aint1 = HospitalBedBlock.bedAboveStandUpOffsets(p_49467_);
        Optional<Vec3> optional2 = HospitalBedBlock.findStandUpPositionAtOffset(p_49464_, p_49465_, p_49466_, aint1, true);
        if (optional2.isPresent()) {
            return optional2;
        }
        Optional<Vec3> optional3 = HospitalBedBlock.findStandUpPositionAtOffset(p_49464_, p_49465_, p_49466_, aint, false);
        if (optional3.isPresent()) {
            return optional3;
        }
        Optional<Vec3> optional4 = HospitalBedBlock.findStandUpPositionAtOffset(p_49464_, p_49465_, blockpos, aint, false);
        return optional4.isPresent() ? optional4 : HospitalBedBlock.findStandUpPositionAtOffset(p_49464_, p_49465_, p_49466_, aint1, false);
    }

    private static Optional<Vec3> findStandUpPositionAtOffset(EntityType<?> p_49470_, CollisionGetter p_49471_, BlockPos p_49472_, int[][] p_49473_, boolean p_49474_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int[] aint : p_49473_) {
            blockpos$mutableblockpos.m_122178_(p_49472_.m_123341_() + aint[0], p_49472_.m_123342_(), p_49472_.m_123343_() + aint[1]);
            Vec3 vec3 = DismountHelper.m_38441_(p_49470_, (CollisionGetter)p_49471_, (BlockPos)blockpos$mutableblockpos, (boolean)p_49474_);
            if (vec3 == null) continue;
            return Optional.of(vec3);
        }
        return Optional.empty();
    }

    public PushReaction m_5537_(BlockState p_49556_) {
        return PushReaction.DESTROY;
    }

    public RenderShape m_7514_(BlockState p_49545_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_49532_) {
        p_49532_.m_61104_(new Property[]{f_54117_, BlockStateProperties.f_61391_, OCCUPIED});
    }

    public BlockEntity m_142194_(BlockPos p_152175_, BlockState p_152176_) {
        return new HospitalBedBlockEntity(p_152175_, p_152176_);
    }

    public void m_6402_(Level p_49499_, BlockPos p_49500_, BlockState p_49501_, @javax.annotation.Nullable LivingEntity p_49502_, ItemStack p_49503_) {
        super.m_6402_(p_49499_, p_49500_, p_49501_, p_49502_, p_49503_);
        if (!p_49499_.f_46443_) {
            BlockPos blockpos = p_49500_.m_121945_((Direction)p_49501_.m_61143_((Property)f_54117_));
            p_49499_.m_7731_(blockpos, (BlockState)p_49501_.m_61124_((Property)BlockStateProperties.f_61391_, (Comparable)BedPart.HEAD), 3);
            p_49499_.m_6289_(p_49500_, Blocks.f_50016_);
            p_49501_.m_60701_((LevelAccessor)p_49499_, p_49500_, 3);
        }
    }

    public DyeColor getColor() {
        return this.color;
    }

    public long m_7799_(BlockState p_49522_, BlockPos p_49523_) {
        BlockPos blockpos = p_49523_.m_5484_((Direction)p_49522_.m_61143_((Property)f_54117_), p_49522_.m_61143_((Property)BlockStateProperties.f_61391_) == BedPart.HEAD ? 0 : 1);
        return Mth.m_14130_((int)blockpos.m_123341_(), (int)p_49523_.m_123342_(), (int)blockpos.m_123343_());
    }

    public boolean m_7357_(BlockState p_49510_, BlockGetter p_49511_, BlockPos p_49512_, PathComputationType p_49513_) {
        return false;
    }

    private static int[][] bedStandUpOffsets(Direction p_49539_, Direction p_49540_) {
        return (int[][])ArrayUtils.addAll((Object[])HospitalBedBlock.bedSurroundStandUpOffsets(p_49539_, p_49540_), (Object[])HospitalBedBlock.bedAboveStandUpOffsets(p_49539_));
    }

    private static int[][] bedSurroundStandUpOffsets(Direction p_49552_, Direction p_49553_) {
        return new int[][]{{p_49553_.m_122429_(), p_49553_.m_122431_()}, {p_49553_.m_122429_() - p_49552_.m_122429_(), p_49553_.m_122431_() - p_49552_.m_122431_()}, {p_49553_.m_122429_() - p_49552_.m_122429_() * 2, p_49553_.m_122431_() - p_49552_.m_122431_() * 2}, {-p_49552_.m_122429_() * 2, -p_49552_.m_122431_() * 2}, {-p_49553_.m_122429_() - p_49552_.m_122429_() * 2, -p_49553_.m_122431_() - p_49552_.m_122431_() * 2}, {-p_49553_.m_122429_() - p_49552_.m_122429_(), -p_49553_.m_122431_() - p_49552_.m_122431_()}, {-p_49553_.m_122429_(), -p_49553_.m_122431_()}, {-p_49553_.m_122429_() + p_49552_.m_122429_(), -p_49553_.m_122431_() + p_49552_.m_122431_()}, {p_49552_.m_122429_(), p_49552_.m_122431_()}, {p_49553_.m_122429_() + p_49552_.m_122429_(), p_49553_.m_122431_() + p_49552_.m_122431_()}};
    }

    private static int[][] bedAboveStandUpOffsets(Direction p_49537_) {
        return new int[][]{{0, 0}, {-p_49537_.m_122429_(), -p_49537_.m_122431_()}};
    }

    public boolean isBed(BlockState state, BlockGetter level, BlockPos pos, @Nullable Entity player) {
        return true;
    }
}

