/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.blocks;

import ca.bradj.questown.QT;
import ca.bradj.questown.blocks.OpenMenuListener;
import ca.bradj.questown.blocks.TownFlagBlock;
import ca.bradj.questown.blocks.TownFlagSubBlock;
import ca.bradj.questown.blocks.TownFlagSubBlocks;
import ca.bradj.questown.blocks.TownFlagSubEntity;
import ca.bradj.questown.core.init.TilesInit;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class JobBoardBlock
extends TownFlagSubBlock<Entity> {
    public static final String ITEM_ID = "job_board_block";
    private final ArrayList<OpenMenuListener> openMenuListeners = new ArrayList();

    public JobBoardBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)MaterialColor.f_76362_).m_60913_(1.0f, 10.0f).m_60955_(), Entity::new, Entity::tick);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH));
    }

    @Override
    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public List<ItemStack> m_7381_(BlockState p_60537_, LootContext.Builder p_60538_) {
        return ImmutableList.of();
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)ctx.m_8125_().m_122424_());
        Level level = ctx.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return blockState;
        }
        ServerLevel sl = (ServerLevel)level;
        ItemStack item = ctx.m_43722_();
        @Nullable TownFlagBlockEntity parent = TownFlagBlock.GetParentFromNBT(sl, item);
        BlockPos matPos = ctx.m_8083_();
        if (parent == null) {
            QT.BLOCK_LOGGER.error("Job Board is not associated to an existing flag", new Object[0]);
            sl.m_7967_((net.minecraft.world.entity.Entity)new ItemEntity((Level)sl, (double)matPos.m_123341_(), (double)matPos.m_123342_(), (double)matPos.m_123343_(), ctx.m_43722_()));
            return Blocks.f_50016_.m_49966_();
        }
        parent.registerJobsBoard(matPos);
        return blockState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51385_) {
        p_51385_.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_});
    }

    public void addOpenMenuListener(OpenMenuListener l) {
        this.openMenuListeners.add(l);
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player p_60506_, InteractionHand p_60507_, BlockHitResult p_60508_) {
        boolean clientSide = p_60504_.m_5776_();
        if (!clientSide) {
            for (OpenMenuListener l : this.openMenuListeners) {
                l.openMenuRequested((ServerPlayer)p_60506_, false);
            }
        }
        return InteractionResult.CONSUME;
    }

    @Override
    protected BlockEntityType<Entity> getTickerEntityType() {
        return (BlockEntityType)TilesInit.JOB_BOARD.get();
    }

    public static class Entity
    extends BlockEntity
    implements TownFlagSubEntity {
        private final List<Runnable> tickListeners = new ArrayList<Runnable>();

        public Entity(BlockPos p_155229_, BlockState p_155230_) {
            super((BlockEntityType)TilesInit.JOB_BOARD.get(), p_155229_, p_155230_);
        }

        @Override
        public Block getBlock() {
            return this.m_58900_().m_60734_();
        }

        @Override
        public void runWhenOrphaned(ServerLevel sl, Block childBlock, BlockPos childPos, BlockPos flagPos) {
            ItemStack toDrop = Items.f_42438_.m_7968_();
            TownFlagBlock.StoreParentOnNBT(toDrop, flagPos);
            TownFlagSubBlocks.dropDrops(sl, childPos, (Collection<ItemStack>)ImmutableList.of((Object)toDrop));
        }

        @Override
        public void addTickListener(Runnable listener) {
            this.tickListeners.add(listener);
        }

        public static void tick(Level level, BlockPos pos, BlockState blockState, Entity entity) {
            entity.tickListeners.forEach(Runnable::run);
        }
    }
}

