/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.blocks;

import ca.bradj.questown.QT;
import ca.bradj.questown.blocks.RoomBlock;
import ca.bradj.questown.blocks.entity.BlockAsRoomEntity;
import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.core.advancements.RoomTrigger;
import ca.bradj.questown.core.init.AdvancementsInit;
import ca.bradj.questown.core.init.ModItemGroup;
import ca.bradj.questown.core.init.TilesInit;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.core.materials.WallType;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.rewards.AddBatchOfQuestsForVisitorReward;
import ca.bradj.questown.town.rewards.AddRandomUpgradeQuest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TownFlagBlock
extends BaseEntityBlock {
    public static final String ITEM_ID = "flag_base";
    public static final Item.Properties ITEM_PROPS = new Item.Properties().m_41491_(ModItemGroup.QUESTOWN_GROUP);
    public static final Property<Boolean> SLEEPING = BooleanProperty.m_61465_((String)"sleeping");
    private Map<Player, Long> informedPlayers = new HashMap<Player, Long>();

    public TownFlagBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76419_).m_60913_(10.0f, 1200.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SLEEPING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51385_) {
        p_51385_.m_61104_(new Property[]{SLEEPING});
    }

    public static String itemId(WallType wallType) {
        return String.format("%s_%s", wallType.asString(), ITEM_ID);
    }

    public static TownFlagBlockEntity GetParentFromNBT(ServerLevel level, ItemStack itemInHand) {
        BlockPos bp = TownFlagBlock.GetParentPosFromNBT(itemInHand);
        if (bp == null) {
            return null;
        }
        BlockEntity oEntity = level.m_7702_(bp);
        if (oEntity instanceof TownFlagBlockEntity) {
            TownFlagBlockEntity e = (TownFlagBlockEntity)oEntity;
            return e;
        }
        return null;
    }

    @Nullable
    public static BlockPos GetParentPosFromNBT(ItemStack itemInHand) {
        if (itemInHand.m_41783_() == null) {
            QT.ITEM_LOGGER.error("Missing NBT tag on {}", itemInHand);
            return null;
        }
        String xTag = String.format("%s.parent_pos_x", "questown");
        if (!itemInHand.m_41783_().m_128441_(xTag)) {
            QT.ITEM_LOGGER.error("Missing X tag from {}", itemInHand.m_41783_());
            return null;
        }
        String yTag = String.format("%s.parent_pos_y", "questown");
        if (!itemInHand.m_41783_().m_128441_(yTag)) {
            QT.ITEM_LOGGER.error("Missing Y tag from {}", itemInHand.m_41783_());
            return null;
        }
        String zTag = String.format("%s.parent_pos_z", "questown");
        if (!itemInHand.m_41783_().m_128441_(zTag)) {
            QT.ITEM_LOGGER.error("Missing Z tag from {}", itemInHand.m_41783_());
            return null;
        }
        int x = itemInHand.m_41784_().m_128451_(xTag);
        int y = itemInHand.m_41784_().m_128451_(yTag);
        int z = itemInHand.m_41784_().m_128451_(zTag);
        BlockPos bp = new BlockPos(x, y, z);
        return bp;
    }

    public static void CopyParentFromNBT(ItemStack input, ItemStack output) {
        if (input.m_41783_() == null) {
            QT.ITEM_LOGGER.error("No parent stored on item: {}", input.m_41783_());
            return;
        }
        String xTag = String.format("%s.parent_pos_x", "questown");
        if (!input.m_41783_().m_128441_(xTag)) {
            QT.ITEM_LOGGER.error("No parent X coord stored on item: {}", input.m_41783_());
            return;
        }
        String yTag = String.format("%s.parent_pos_y", "questown");
        if (!input.m_41783_().m_128441_(yTag)) {
            QT.ITEM_LOGGER.error("No parent Y coord stored on item: {}", input.m_41783_());
            return;
        }
        String zTag = String.format("%s.parent_pos_z", "questown");
        if (!input.m_41783_().m_128441_(zTag)) {
            QT.ITEM_LOGGER.error("No parent Z coord stored on item: {}", input.m_41783_());
            return;
        }
        output.m_41784_().m_128405_(xTag, input.m_41783_().m_128451_(xTag));
        output.m_41784_().m_128405_(yTag, input.m_41783_().m_128451_(yTag));
        output.m_41784_().m_128405_(zTag, input.m_41783_().m_128451_(zTag));
    }

    @Nullable
    private static InteractionResult convertItemInHand(ServerLevel level, ServerPlayer player, InteractionHand hand, TownFlagBlockEntity entity) {
        UnmodifiableIterator unmodifiableIterator;
        ItemStack itemInHand = player.m_21120_(hand);
        if (itemInHand.m_41720_().equals(Items.f_42329_)) {
            entity.giveBonusFood(player);
            return InteractionResult.CONSUME;
        }
        if (itemInHand.m_41720_().equals(Items.f_42415_) && (unmodifiableIterator = entity.getQuestHandle().getVillagersWithQuests().iterator()).hasNext()) {
            VillagerUUID uuid = (VillagerUUID)unmodifiableIterator.next();
            entity.addImmediateReward(new AddRandomUpgradeQuest((TownInterface)entity, uuid));
            return InteractionResult.m_19078_((boolean)false);
        }
        if (itemInHand.m_41720_().equals(Items.f_41912_)) {
            UUID randomVillager = entity.getRandomVillager();
            entity.addImmediateReward(new AddBatchOfQuestsForVisitorReward(entity, randomVillager));
            return InteractionResult.m_19078_((boolean)false);
        }
        if (itemInHand.m_41720_().equals(Items.f_42620_)) {
            entity.getVillagerHandle().recallVillagers();
            return InteractionResult.m_19078_((boolean)false);
        }
        ItemStack converted = null;
        for (Supplier<RoomBlock> blockSupplier : BlockAsRoomEntity.ALL) {
            if (!itemInHand.m_41720_().equals(blockSupplier.get().m_5456_())) continue;
            converted = itemInHand.m_41777_();
        }
        if (itemInHand.m_41720_().equals(Items.f_42398_)) {
            converted = ((Item)ItemsInit.TOWN_WAND.get()).m_7968_();
        }
        if (itemInHand.m_41720_().equals(ItemsInit.TOWN_WAND.get())) {
            converted = Items.f_42398_.m_7968_();
        }
        if (ImmutableList.of((Object)((Item)ItemsInit.WELCOME_MAT_BLOCK.get()), (Object)((Item)ItemsInit.STOCK_REQUEST_CLIPBOARD.get())).contains((Object)itemInHand.m_41720_())) {
            converted = itemInHand;
        }
        if (Ingredient.m_204132_((TagKey)ItemTags.f_13157_).test(itemInHand)) {
            converted = ((Item)ItemsInit.JOB_BOARD_BLOCK.get()).m_7968_();
        }
        if (Ingredient.m_204132_((TagKey)ItemTags.f_13177_).test(itemInHand)) {
            converted = ((Item)ItemsInit.WELCOME_MAT_BLOCK.get()).m_7968_();
        }
        if (Ingredient.m_204132_((TagKey)ItemTags.f_13179_).test(itemInHand)) {
            converted = ((Item)ItemsInit.TOWN_DOOR.get()).m_7968_();
        }
        if (itemInHand.m_41720_().equals(ItemsInit.TOWN_DOOR.get())) {
            converted = ((Item)ItemsInit.TOWN_DOOR.get()).m_7968_();
        }
        if (itemInHand.m_41720_().equals(Items.f_42594_)) {
            converted = ((Item)ItemsInit.FALSE_DOOR.get()).m_7968_();
        }
        if (itemInHand.m_41720_().equals(ItemsInit.FALSE_DOOR.get())) {
            converted = ((Item)ItemsInit.FALSE_WALL_BLOCK.get()).m_7968_();
        }
        if (itemInHand.m_41720_().equals(ItemsInit.FALSE_WALL_BLOCK.get())) {
            converted = ((Item)ItemsInit.FALSE_DOOR.get()).m_7968_();
        }
        if (Ingredient.m_204132_((TagKey)Tags.Items.FENCE_GATES).test(itemInHand)) {
            converted = ((Item)ItemsInit.TOWN_FENCE_GATE.get()).m_7968_();
        }
        if (itemInHand.m_41720_().equals(ItemsInit.TOWN_FENCE_GATE.get())) {
            converted = ((Item)ItemsInit.TOWN_FENCE_GATE.get()).m_7968_();
        }
        if (itemInHand.m_41720_().equals(Items.f_42027_)) {
            converted = ((Item)ItemsInit.PLATE_BLOCK.get()).m_7968_();
        }
        if (Ingredient.m_204132_((TagKey)ItemTags.f_13146_).test(itemInHand.m_41720_().m_7968_())) {
            converted = ((Item)ItemsInit.HOSPITAL_BED.get()).m_7968_();
        }
        if (((Item)ItemsInit.HOSPITAL_BED.get()).equals(itemInHand.m_41720_())) {
            converted = TownFlagBlock.GetFlagInputFromItemNBT(itemInHand);
        }
        if (converted != null) {
            TownFlagBlock.StoreFlagInputOnOutputNBT(itemInHand, converted);
            player.m_21008_(hand, converted);
            QT.FLAG_LOGGER.debug("{} created at {}", ForgeRegistries.ITEMS.getKey((Object)converted.m_41720_()), entity.getTownFlagBasePos());
            ItemStack toDrop = null;
            if (itemInHand.m_41613_() > 1) {
                toDrop = itemInHand.m_41777_();
                toDrop.m_41774_(1);
            }
            if (toDrop != null) {
                BlockPos flagPos = player.m_20183_();
                level.m_7967_((Entity)new ItemEntity((Level)level, (double)flagPos.m_123341_(), (double)flagPos.m_123342_(), (double)flagPos.m_123343_(), toDrop));
            }
            TownFlagBlock.StoreParentOnNBT(converted, entity.getTownFlagBasePos());
            QT.FLAG_LOGGER.debug("{} has been paired with {} at {}", ForgeRegistries.ITEMS.getKey((Object)converted.m_41720_()), entity.getUUID(), entity.getTownFlagBasePos());
            if (converted.m_41720_().equals(ItemsInit.TOWN_WAND.get())) {
                AdvancementsInit.ROOM_TRIGGER.trigger(player, RoomTrigger.Triggers.WandGet);
            }
            return InteractionResult.m_19078_((boolean)false);
        }
        return null;
    }

    public static void StoreParentOnNBT(ItemStack itemInHand, BlockPos p) {
        TownFlagBlock.getParentData(p).forEach((key, value) -> itemInHand.m_41784_().m_128405_(key, value.intValue()));
    }

    public static ImmutableMap<String, Integer> getParentData(BlockPos parentPos) {
        return ImmutableMap.of((Object)String.format("%s.parent_pos_x", "questown"), (Object)parentPos.m_123341_(), (Object)String.format("%s.parent_pos_y", "questown"), (Object)parentPos.m_123342_(), (Object)String.format("%s.parent_pos_z", "questown"), (Object)parentPos.m_123343_());
    }

    public static void StoreFlagInputOnOutputNBT(ItemStack input, ItemStack output) {
        String key = String.format("%s.flag_input_itemstack", "questown");
        output.m_41784_().m_128365_(key, (Tag)input.serializeNBT());
    }

    @Nullable
    public static ItemStack GetFlagInputFromItemNBT(ItemStack item) {
        String key = String.format("%s.flag_input_itemstack", "questown");
        CompoundTag serialized = item.m_41784_().m_128469_(key);
        if (serialized.m_128456_()) {
            return null;
        }
        return ItemStack.m_41712_((CompoundTag)serialized);
    }

    public void m_6256_(BlockState p_60499_, Level level, BlockPos p_60501_, Player player) {
        super.m_6256_(p_60499_, level, p_60501_, player);
        if (level.m_5776_()) {
            return;
        }
        if (this.informedPlayers.containsKey(player) && level.m_46467_() - this.informedPlayers.get(player) < 1000L) {
            return;
        }
        Compat.sendMessage((ServerPlayer)player, Compat.translatable("messages.town_flag.damaged"));
        this.informedPlayers.put(player, level.m_46467_());
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TownFlagBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> entityType) {
        return level.f_46443_ ? null : TownFlagBlock.m_152132_(entityType, (BlockEntityType)((BlockEntityType)TilesInit.TOWN_FLAG.get()), TownFlagBlockEntity::tick);
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult p_60508_) {
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.m_19078_((boolean)true);
        }
        ServerLevel sl = (ServerLevel)level;
        Optional oEntity = level.m_141902_(pos, (BlockEntityType)TilesInit.TOWN_FLAG.get());
        if (oEntity.isEmpty()) {
            return InteractionResult.m_19078_((boolean)true);
        }
        TownFlagBlockEntity entity = (TownFlagBlockEntity)oEntity.get();
        InteractionResult sidedSuccess = TownFlagBlock.convertItemInHand(sl, (ServerPlayer)player, hand, entity);
        if (sidedSuccess != null) {
            return sidedSuccess;
        }
        if (((TownFlagBlockEntity)oEntity.get()).isInitialized()) {
            ((TownFlagBlockEntity)oEntity.get()).getVillagerHandle().showMultiStatusUI((ServerPlayer)player);
        } else {
            if (!((TownFlagBlockEntity)oEntity.get()).isInitializing()) {
                ((TownFlagBlockEntity)oEntity.get()).initializeFreshFlag(true);
            }
            player.m_5661_(Compat.translatable("messages.town_flag.loading"), false);
        }
        return InteractionResult.m_19078_((boolean)false);
    }
}

