/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.blocks;

import ca.bradj.questown.QT;
import ca.bradj.questown.blocks.OnOrphaned;
import ca.bradj.questown.blocks.TownFlagBlock;
import ca.bradj.questown.blocks.TownFlagSubEntity;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public final class TownFlagSubBlocks {
    private final Stack<BlockPos> pending = new Stack();
    private final Map<BlockPos, Integer> pendingTicks = new HashMap<BlockPos, Integer>();
    private final Map<BlockPos, Integer> ticksWithoutParent = new HashMap<BlockPos, Integer>();
    private final Map<BlockPos, Integer> ticksWithoutChild = new HashMap<BlockPos, Integer>();
    private final Map<BlockPos, OnOrphaned> runOnOrphaned = new HashMap<BlockPos, OnOrphaned>();
    private final BlockPos flagPos;

    public TownFlagSubBlocks(BlockPos blockPos) {
        this.flagPos = blockPos;
    }

    public void parentTick(ServerLevel sl, BlockPos blockPos) {
        BlockEntity en = sl.m_7702_(blockPos);
        if (en instanceof TownFlagBlockEntity) {
            BlockState state = sl.m_8055_(blockPos);
            sl.m_46597_(blockPos, (BlockState)state.m_61124_(TownFlagBlock.SLEEPING, (Comparable)Boolean.valueOf(false)));
        }
        if (!this.pending.isEmpty()) {
            BlockPos popped = this.pending.pop();
            try {
                if (!this.initialize(sl, popped)) {
                    this.pending.push(popped);
                }
            }
            catch (IllegalStateException e) {
                QT.FLAG_LOGGER.error("Giving up on detecting sub block at {}: {}", popped, e);
            }
        }
        ImmutableMap.Builder allZeros = ImmutableMap.builder();
        this.ticksWithoutParent.forEach((k, b) -> allZeros.put(k, (Object)0));
        this.ticksWithoutParent.putAll((Map<BlockPos, Integer>)allZeros.build());
        ImmutableMap.Builder twoc = ImmutableMap.builder();
        this.ticksWithoutChild.forEach((bp, v) -> {
            if (v > Compat.configGet(Config.FLAG_SUB_BLOCK_REMOVED_TICKS).get()) {
                OnOrphaned remove = this.runOnOrphaned.remove(bp);
                if (remove != null) {
                    remove.run(sl, (BlockPos)bp, this.flagPos);
                }
                this.ticksWithoutParent.remove(bp);
                return;
            }
            twoc.put(bp, (Object)(v + 1));
        });
        this.ticksWithoutChild.clear();
        this.ticksWithoutChild.putAll((Map<BlockPos, Integer>)twoc.build());
    }

    public void tick(ServerLevel sl, BlockPos pos) {
        if (((Boolean)sl.m_8055_(this.flagPos).m_61143_(TownFlagBlock.SLEEPING)).booleanValue()) {
            this.ticksWithoutParent.put(pos, 0);
            return;
        }
        this.ticksWithoutChild.put(pos, 0);
        Integer twop = this.ticksWithoutParent.get(pos);
        if (twop == null) {
            return;
        }
        this.ticksWithoutParent.put(pos, twop + 1);
        if (twop >= Compat.configGet(Config.FLAG_SUB_BLOCK_RETENTION_TICKS).get()) {
            QT.BLOCK_LOGGER.debug("Parent has stopped ticking. Entity removed at {} on tick {}", pos, Util.getTick(sl));
            sl.m_7471_(pos, true);
            OnOrphaned remove = this.runOnOrphaned.remove(pos);
            if (remove != null) {
                remove.run(sl, pos, this.flagPos);
            }
        }
    }

    public static void dropDrops(ServerLevel sl, BlockPos pos, Collection<ItemStack> drops) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        drops.forEach(i -> sl.m_7967_((Entity)new ItemEntity((Level)sl, (double)x, (double)y, (double)z, i)));
    }

    private boolean initialize(ServerLevel sl, BlockPos pop) {
        BlockEntity e = sl.m_7702_(pop);
        if (e instanceof TownFlagSubEntity) {
            TownFlagSubEntity s = (TownFlagSubEntity)e;
            this.ticksWithoutParent.put(pop, 0);
            Block blockBeforeRemoval = s.getBlock();
            this.runOnOrphaned.put(pop, (a, b, c) -> s.runWhenOrphaned(a, blockBeforeRemoval, b, c));
            s.addTickListener(() -> this.tick(sl, pop));
            QT.FLAG_LOGGER.debug("Registered sub block of town flag: {}", s.getClass().getName());
            return true;
        }
        Integer newVal = this.pendingTicks.compute(pop, TownFlagSubBlocks::increment);
        if (newVal > Compat.configGet(Config.FLAG_SUB_BLOCK_DETECTION_TICKS).get()) {
            throw new IllegalStateException("Could not register sub block because wrong entity type: " + String.valueOf(e));
        }
        return false;
    }

    @NotNull
    private static Integer increment(BlockPos p, Integer v) {
        return v == null ? 1 : v + 1;
    }

    public void register(BlockPos matPos) {
        this.pending.push(matPos);
    }
}

