/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.blocks;

import ca.bradj.questown.QT;
import ca.bradj.questown.blocks.TownFlagBlock;
import ca.bradj.questown.blocks.TownFlagSubBlock;
import ca.bradj.questown.blocks.TownFlagSubBlocks;
import ca.bradj.questown.blocks.TownFlagSubEntity;
import ca.bradj.questown.core.init.TilesInit;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WelcomeMatBlock
extends TownFlagSubBlock<Entity> {
    public static final String ITEM_ID = "welcome_mat_block";
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public WelcomeMatBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)MaterialColor.f_76362_).m_60913_(1.0f, 10.0f).m_60910_(), Entity::new, Entity::tick);
    }

    public List<ItemStack> m_7381_(BlockState p_60537_, LootContext.Builder p_60538_) {
        return ImmutableList.of();
    }

    @Override
    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)ctx.m_8125_().m_122424_());
        Level level = ctx.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return blockState;
        }
        ServerLevel sl = (ServerLevel)level;
        ItemStack item = ctx.m_43722_();
        @Nullable TownFlagBlockEntity parent = TownFlagBlock.GetParentFromNBT(sl, item);
        BlockPos matPos = ctx.m_8083_();
        if (parent == null) {
            QT.BLOCK_LOGGER.error("Welcome mat is not associated to an existing flag", new Object[0]);
            sl.m_7967_((net.minecraft.world.entity.Entity)new ItemEntity((Level)sl, (double)matPos.m_123341_(), (double)matPos.m_123342_(), (double)matPos.m_123343_(), ctx.m_43722_()));
            return Blocks.f_50016_.m_49966_();
        }
        parent.registerWelcomeMat(matPos);
        return blockState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51385_) {
        p_51385_.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_});
    }

    public BlockState m_6843_(BlockState p_54125_, Rotation p_54126_) {
        return (BlockState)p_54125_.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)p_54126_.m_55954_((Direction)p_54125_.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    public BlockState m_6943_(BlockState p_54122_, Mirror p_54123_) {
        return p_54122_.m_60717_(p_54123_.m_54846_((Direction)p_54122_.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    @Override
    protected BlockEntityType<Entity> getTickerEntityType() {
        return (BlockEntityType)TilesInit.WELCOME_MAT.get();
    }

    public static class Entity
    extends BlockEntity
    implements TownFlagSubEntity {
        private final List<Runnable> tickListeners = new ArrayList<Runnable>();

        public Entity(BlockPos p_155229_, BlockState p_155230_) {
            super((BlockEntityType)TilesInit.WELCOME_MAT.get(), p_155229_, p_155230_);
        }

        @Override
        public Block getBlock() {
            return this.m_58900_().m_60734_();
        }

        @Override
        public void runWhenOrphaned(ServerLevel sl, Block childBlock, BlockPos childPos, BlockPos flagPos) {
            ItemStack toDrop = Items.f_41968_.m_7968_();
            TownFlagBlock.StoreParentOnNBT(toDrop, flagPos);
            TownFlagSubBlocks.dropDrops(sl, childPos, (Collection<ItemStack>)ImmutableList.of((Object)toDrop));
        }

        @Override
        public void addTickListener(Runnable listener) {
            this.tickListeners.add(listener);
        }

        public static void tick(Level level, BlockPos pos, BlockState blockState, Entity entity) {
            entity.tickListeners.forEach(Runnable::run);
        }
    }
}

