/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.blocks.entity;

import ca.bradj.questown.core.init.TagsInit;
import ca.bradj.questown.core.init.TilesInit;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.core.network.SyncBlockItemMessage;
import ca.bradj.questown.integration.minecraft.MCContainerInterface;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.jobs.leaver.RankBoost;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class FoodDisplayEntity
extends BlockEntity
implements MCContainerInterface {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);

    public FoodDisplayEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)TilesInit.FOOD_DISPLAY.get(), p_155229_, p_155230_);
    }

    public void m_142466_(CompoundTag p_155349_) {
        super.m_142466_(p_155349_);
        this.items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)p_155349_, this.items);
        for (int i = 0; i < this.items.size(); ++i) {
            SyncBlockItemMessage message = new SyncBlockItemMessage(this.m_58899_(), (ItemStack)this.items.get(i), i);
            QuestownNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)message);
        }
    }

    protected void m_183515_(CompoundTag p_187489_) {
        super.m_183515_(p_187489_);
        ContainerHelper.m_18973_((CompoundTag)p_187489_, this.items);
    }

    public Collection<ItemStack> getItems() {
        return this.items;
    }

    public boolean addFood(ItemStack itemStack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.doSetItem(i, MCTownItem.fromMCItemStack(itemStack))) continue;
            SyncBlockItemMessage message = new SyncBlockItemMessage(this.m_58899_(), itemStack, i);
            QuestownNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)message);
            return true;
        }
        return false;
    }

    public ItemStack removeFood() {
        for (int i = 0; i < this.items.size(); ++i) {
            MCTownItem removed = this.removeItem(i);
            if (removed == null || removed.isEmpty()) continue;
            SyncBlockItemMessage message = new SyncBlockItemMessage(this.m_58899_(), ItemStack.f_41583_, i);
            QuestownNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)message);
            return removed.toMCItemStack();
        }
        return ItemStack.f_41583_;
    }

    @Override
    public MCTownItem removeItem(int index) {
        ItemStack itemStack = (ItemStack)this.items.get(index);
        if (itemStack.m_41619_()) {
            return MCTownItem.Air();
        }
        this.items.set(index, (Object)ItemStack.f_41583_);
        return MCTownItem.fromMCItemStack(itemStack);
    }

    @Override
    public boolean setItem(int index, MCTownItem item) {
        boolean didSet = this.doSetItem(index, item);
        if (didSet) {
            SyncBlockItemMessage message = new SyncBlockItemMessage(this.m_58899_(), item.toQTItemStack(), index);
            QuestownNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)message);
        }
        return didSet;
    }

    public boolean doSetItem(int index, MCTownItem item) {
        if (item.isEmpty()) {
            if (((ItemStack)this.items.get(index)).m_41619_()) {
                return false;
            }
            this.items.set(index, (Object)item.toQTItemStack());
            return true;
        }
        if (((ItemStack)this.items.get(index)).m_41619_() && this.canAcceptIfSpaceAllows(item)) {
            this.items.set(index, (Object)item.toQTItemStack());
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public MCTownItem getItem(int i) {
        return MCTownItem.fromMCItemStack((ItemStack)this.items.get(i));
    }

    @Override
    public boolean isFull() {
        return this.items.stream().noneMatch(ItemStack::m_41619_);
    }

    @Override
    public String toShortString() {
        return this.items.toString();
    }

    @Override
    public String toShortString(boolean includeAir) {
        return this.items.toString();
    }

    @Override
    public boolean canAcceptIfSpaceAllows(MCTownItem item) {
        return Ingredient.m_204132_(TagsInit.Items.VILLAGER_FOOD).test(item.toQTItemStack());
    }

    @Override
    public RankBoost getItemAcceptanceRankBoost() {
        return RankBoost.SLIGHTLY_PREFERRED;
    }
}

