/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.blocks.entity;

import ca.bradj.questown.blocks.SeedBinBlock;
import ca.bradj.questown.core.init.TilesInit;
import ca.bradj.questown.integration.minecraft.MCContainerInterface;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.jobs.leaver.RankBoost;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SeedBinBlockEntity
extends BlockEntity
implements MCContainerInterface {
    public static final Item INNER_ITEM = Items.f_42404_;

    public SeedBinBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)TilesInit.SEED_BIN.get(), p_155229_, p_155230_);
    }

    @Override
    public int size() {
        return SeedBinBlock.getLevel(this.m_58900_());
    }

    @Override
    public MCTownItem getItem(int i) {
        if (i > SeedBinBlock.getLevel(this.m_58900_())) {
            return MCTownItem.Air();
        }
        return MCTownItem.fromMCItemStack(INNER_ITEM.m_7968_());
    }

    @Override
    public MCTownItem removeItem(int index) {
        Level level;
        MCTownItem item = this.getItem(index);
        if (!item.isEmpty() && (level = this.m_58904_()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            BlockState bs = this.m_58900_();
            int curLevel = SeedBinBlock.getLevel(bs);
            if (curLevel == 0) {
                return MCTownItem.Air();
            }
            sl.m_46597_(this.m_58899_(), SeedBinBlock.reduceLevel(bs));
        }
        return item;
    }

    @Override
    public boolean isFull() {
        return SeedBinBlock.isFull(this.m_58900_());
    }

    @Override
    public String toShortString() {
        return "SeedBin[" + SeedBinBlock.getLevel(this.m_58900_()) + "]";
    }

    @Override
    public String toShortString(boolean includeAir) {
        return this.toShortString();
    }

    @Override
    public boolean canAcceptIfSpaceAllows(MCTownItem item) {
        return item.get().equals(INNER_ITEM);
    }

    @Override
    public RankBoost getItemAcceptanceRankBoost() {
        return RankBoost.SLIGHTLY_PREFERRED;
    }

    @Override
    public boolean setItem(int index, MCTownItem item) {
        return SeedBinBlock.addSeed(this.f_58857_, this.m_58899_(), this.m_58900_());
    }
}

