/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import org.jetbrains.annotations.NotNull;

public class DebugLogArgument
implements ArgumentType<String> {
    private static final ImmutableList<String> debugLogIds;
    public static final String AWARENESS_COMPUTE;
    public static final String JOB_POSSIBILITIES_COMPUTE;
    public static final String QUEST_BATCH_COMPUTE_NEXT;
    public static final String TIME_WARP;
    public static final String TOWN_STATE_CHANGES;
    public static final String VILLAGER_NAVIGATION;
    public static final String JOB_LOGIC;
    public static final String SAMPLING;
    public static final String VILLAGER_STATS;

    private static String add(ImmutableList.Builder<String> b, String val) {
        b.add((Object)val);
        return val;
    }

    public DebugLogArgument(CommandBuildContext ctx) {
    }

    @NotNull
    public static ArgumentType<String> debugLogs(CommandBuildContext ctx) {
        return new DebugLogArgument(ctx);
    }

    public static String getLog(CommandContext<CommandSourceStack> ctx, String name) {
        return (String)ctx.getArgument(name, String.class);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        return reader.readString();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        debugLogIds.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    static {
        ImmutableList.Builder b = ImmutableList.builder();
        AWARENESS_COMPUTE = DebugLogArgument.add((ImmutableList.Builder<String>)b, "awareness_compute");
        JOB_POSSIBILITIES_COMPUTE = DebugLogArgument.add((ImmutableList.Builder<String>)b, "job_possibilities_compute");
        QUEST_BATCH_COMPUTE_NEXT = DebugLogArgument.add((ImmutableList.Builder<String>)b, "quest_batch_compute_next");
        TIME_WARP = DebugLogArgument.add((ImmutableList.Builder<String>)b, "time_warp");
        TOWN_STATE_CHANGES = DebugLogArgument.add((ImmutableList.Builder<String>)b, "town_state_changes");
        VILLAGER_NAVIGATION = DebugLogArgument.add((ImmutableList.Builder<String>)b, "villager_navigation");
        JOB_LOGIC = DebugLogArgument.add((ImmutableList.Builder<String>)b, "job_logic");
        SAMPLING = DebugLogArgument.add((ImmutableList.Builder<String>)b, "sampling");
        VILLAGER_STATS = DebugLogArgument.add((ImmutableList.Builder<String>)b, "villager_stats");
        debugLogIds = b.build();
    }
}

