/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core;

import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final String VILLAGE_START_QUESTS = "Village start quests";
    public static final String FILENAME = "questown-server.toml";
    public static final ForgeConfigSpec.ConfigValue<Integer> DOOR_SEARCH_RADIUS;
    public static final ForgeConfigSpec.ConfigValue<Integer> TOWN_TICK_RADIUS;
    public static final ForgeConfigSpec.ConfigValue<Integer> CAMPFIRE_SEARCH_RADIUS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> LOG_QUEST_BATCH_GENERATION;
    public static final ForgeConfigSpec.ConfigValue<Integer> IDEAL_QUEST_THRESHOLD_TICKS;
    public static final ForgeConfigSpec.ConfigValue<Integer> QUEST_GENERATION_MAX_TICKS;
    public static final ForgeConfigSpec.ConfigValue<Integer> DEFAULT_ITEM_WEIGHT;
    public static final ForgeConfigSpec.ConfigValue<Integer> FARM_ACTION_INTERVAL;
    public static final ForgeConfigSpec.ConfigValue<Integer> BAKING_TIME_REQUIRED_BASELINE;
    public static final ForgeConfigSpec.ConfigValue<Integer> TICK_SAMPLING_RATE;
    public static final ForgeConfigSpec.ConfigValue<Integer> MIN_WEIGHT_PER_QUEST_BATCH;
    public static final ForgeConfigSpec.ConfigValue<Integer> QUEST_BATCH_VILLAGER_BOOST_FACTOR;
    public static final ForgeConfigSpec.ConfigValue<Integer> BIOME_SCAN_RADIUS;
    public static final ForgeConfigSpec.ConfigValue<Long> MAX_DOWNTIME_TICKS;
    public static final ForgeConfigSpec.ConfigValue<Long> MAX_TICKS_BETWEEN_DOWNTIME;
    public static final ForgeConfigSpec.ConfigValue<Integer> WANDER_GIVEUP_TICKS;
    public static final ForgeConfigSpec.ConfigValue<Long> VILLAGER_DISTRACT_DURATION;
    public static final ForgeConfigSpec.ConfigValue<Long> VILLAGER_DISTRACT_COOLDOWN;
    public static final ForgeConfigSpec.ConfigValue<Integer> FARMER_WEEDS_RARITY;
    public static final ForgeConfigSpec.ConfigValue<Integer> SMELTER_WORK_REQUIRED;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SCAN_FOR_DOORS;
    public static final ForgeConfigSpec.ConfigValue<Double> DUPLICATE_QUEST_COST_FACTOR;
    public static final ForgeConfigSpec.ConfigValue<Boolean> INFINITE_TOWN_DOORS;
    public static final ForgeConfigSpec.ConfigValue<Integer> FLAG_SUB_BLOCK_RETENTION_TICKS;
    public static final ForgeConfigSpec.ConfigValue<Integer> FLAG_SUB_BLOCK_REMOVED_TICKS;
    public static final ForgeConfigSpec.ConfigValue<Integer> FLAG_SUB_BLOCK_DETECTION_TICKS;
    public static final ForgeConfigSpec.ConfigValue<Integer> META_ROOM_DIAMETER;
    public static final ForgeConfigSpec.ConfigValue<Integer> GATHERER_TIME_REQUIRED_BASELINE;
    public static final ForgeConfigSpec.ConfigValue<Integer> GATHERER_QUARTER_DAY_LOOT_AMOUNT;
    public static final ForgeConfigSpec.ConfigValue<Integer> GATHERER_HALF_DAY_LOOT_AMOUNT;
    public static final ForgeConfigSpec.ConfigValue<Integer> GATHERER_FULL_DAY_LOOT_AMOUNT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> JOB_BOARD_ENABLED;
    public static final ForgeConfigSpec.ConfigValue<Long> WORK_SEEKER_COOLDOWN;
    public static final ForgeConfigSpec.ConfigValue<Long> WORKED_RECENTLY_TICKS;
    public static final ForgeConfigSpec.ConfigValue<Double> MIN_JOB_ACCEPTANCE;
    public static final ForgeConfigSpec.ConfigValue<Double> PREFERRED_JOB_ACCEPTANCE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CRASH_ON_INVALID_JOBS;
    public static final ForgeConfigSpec.ConfigValue<Long> WORK_PRECOMPUTE_FREQUENCY;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CRASH_ON_FAILED_WARP;
    public static final ForgeConfigSpec.ConfigValue<Integer> TIME_WARP_MAX_TICKS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> LOG_WARP_RESULT;
    public static final ForgeConfigSpec.ConfigValue<Integer> BASE_MAX_LOOP;
    public static final ForgeConfigSpec.ConfigValue<Long> MAX_INITIAL_TICKS_WITHOUT_SUPPLIES;
    public static final ForgeConfigSpec.ConfigValue<Long> MAX_TICKS_WITHOUT_SUPPLIES;
    public static final ForgeConfigSpec.ConfigValue<Long> MAX_STICK_TICKS_WITH_TARGET;
    public static final ForgeConfigSpec.ConfigValue<Integer> BASE_FULLNESS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> HUNGER_ENABLED;
    public static final ForgeConfigSpec.ConfigValue<Long> BLOCK_CLAIMS_TICK_LIMIT;
    public static final ForgeConfigSpec.ConfigValue<Long> MAX_TICKS_WITHOUT_DINING_TABLE;
    public static final ForgeConfigSpec.ConfigValue<Long> DAMAGE_TICKS;
    public static final ForgeConfigSpec.ConfigValue<Long> MOOD_TICK_INTERVAL;
    public static final ForgeConfigSpec.ConfigValue<Integer> NEUTRAL_MOOD;
    public static final ForgeConfigSpec.ConfigValue<Long> MOOD_EFFECT_DURATION_ATE_UNCOMFORTABLY;
    public static final ForgeConfigSpec.ConfigValue<Long> MOOD_EFFECT_DURATION_ATE_COMFORTABLY;
    public static final ForgeConfigSpec.ConfigValue<Integer> MAX_ROOM_DIMENSION;
    public static final ForgeConfigSpec.ConfigValue<Integer> MAX_ROOM_SCAN_ITERATIONS;
    public static final ForgeConfigSpec.ConfigValue<Integer> EXPERIENCE_REQUIRED_AT_LEVEL_1;
    public static final ForgeConfigSpec.ConfigValue<Double> EXPERIENCE_RAMP_FACTOR;
    public static final ForgeConfigSpec.ConfigValue<Long> FLAG_TICK_INTERVAL;
    public static final ForgeConfigSpec.ConfigValue<Integer> ECONOMIC_RECORDS_DEPTH;
    public static final ForgeConfigSpec.ConfigValue<Double> NORMAL_BED_HEAL_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<Double> HOSPITAL_BED_HEAL_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<Integer> JOB_TREE_GROWTH;

    static {
        BUILDER.push("Questown.Config.Scanning");
        SCAN_FOR_DOORS = BUILDER.comment("RISKY: Set true to scan for vanilla doors in a radius around the town flag during room detection. This may be prone to crashes if rooms get too complex.").define("ScanForDoors", false);
        DOOR_SEARCH_RADIUS = BUILDER.comment("The radius (around the town flag) where this mod will search for doors for room detection").define("DoorSearchRadius", (Object)100);
        TOWN_TICK_RADIUS = BUILDER.comment("The radius (around the town flag) where this mod will search for players. If no players are found, the flag will stop ticking.").define("TownTickRadius", (Object)10000);
        CAMPFIRE_SEARCH_RADIUS = BUILDER.comment("The radius (around the town flag) where this mod will search for campfires which attract visitors").define("CampfireSearchRadius", (Object)10);
        BIOME_SCAN_RADIUS = BUILDER.comment("The radius of chunks that will be scanned outward (in a plus shape) from the flag for the purpose of populating gatherer loot").defineInRange("BiomeScanRadius", 20, 0, 100);
        MAX_ROOM_DIMENSION = BUILDER.comment("The maximum length or width of a room that can be detected").defineInRange("MaxRoomDimension", 20, 2, 100);
        MAX_ROOM_SCAN_ITERATIONS = BUILDER.comment("The maximum number of ticks that will be spent searching for town rooms").defineInRange("MaxRoomScanIterations", 1000, 1, 24000);
        BUILDER.pop();
        BUILDER.push("Quests").comment("Quests are pre-generated as soon as possible. When a batch of quests is consumed, another pre-generation begins. These options control that process.");
        LOG_QUEST_BATCH_GENERATION = BUILDER.comment("If set to True, quest pre-generation will be printed verbosely to the debug logs. This can be quite noisy.").define("LogQuestBatchGeneration", false);
        IDEAL_QUEST_THRESHOLD_TICKS = BUILDER.comment("When a new batch of quests is added, the mod makes several attempts to find a random, complex room quest to add to the batch. This setting determines how many ticks it will try before giving up and filling the empty space with simpler quests.").define("IdealQuestThresholdTicks", (Object)40);
        QUEST_GENERATION_MAX_TICKS = BUILDER.comment("When a new batch of quests is added, the mod makes several attempts to find quests to add to the batch randomly. This determines how many ticks it will try before giving up and leaving the remaining space empty.").define("QuestGenerationMaxTicks", (Object)50);
        DEFAULT_ITEM_WEIGHT = BUILDER.comment("The default weight that will be assigned to items when choosing new quests. See questown-item-weights-server.toml").define("DefaultItemWeight", (Object)100);
        MIN_WEIGHT_PER_QUEST_BATCH = BUILDER.comment("Minimum weight of quests in a batch. Quests are weighted by the items in the room. See questown-item-weights-server.toml").defineInRange("MinWeightPerQuestBatchV2", 50, 0, 500);
        QUEST_BATCH_VILLAGER_BOOST_FACTOR = BUILDER.comment("The minimum weight for a quest batch includes this factor, which is multiplied by the number of villagers. This causes a village to have an exponential difficulty curve as it grows.").defineInRange("QuestBatchVillagerBoostFactor", 100, 0, 500);
        DUPLICATE_QUEST_COST_FACTOR = BUILDER.comment("When new batches of quests are calculated, a request for a room to be built AGAIN is more expensive. This is done to discourage lots of repeated quests. This factor determines how much more expensive it is.").defineInRange("DuplicateQuestCostFactor", 1.5, 1.0, 100.0);
        BUILDER.pop();
        BUILDER.push("Jobs");
        JOB_TREE_GROWTH = BUILDER.comment("The maximum number of sub-jobs that become available for unlocking when a job is unlocked").comment("For example, if \"baker\" is a pre-requisite for \"bread\", \"cake\", and \"cookies\", ").comment("and \"baker\" is unlocked when this is set to 2, only 2 jobs from \"bread\", \"cakes\" and \"cookies\" ").comment("will become available for unlocking.").defineInRange("JobTreeGrowth", 2, 1, 10);
        MAX_INITIAL_TICKS_WITHOUT_SUPPLIES = BUILDER.comment("If the town is missing the supplies that the villager needs to do their job, they will wait some time for those supplies to be generated/added. After these ticks, they will give up and go back to the job board").defineInRange("MaxInitialTicksWithoutSupplies", 100L, 1L, 24000L);
        MAX_TICKS_WITHOUT_SUPPLIES = BUILDER.comment("See MaxInitialTicksWithoutSupplies. But this timer applies after at least one ingredient have been added.").defineInRange("MaxTicksWithoutSuppliesV2", 1000L, 1L, 24000L);
        MAX_STICK_TICKS_WITH_TARGET = BUILDER.comment("If the villager is trying to move to a target, but hasn't moved in this many ticks, they will be nudged to try and reset navigation").defineInRange("MaxStuckTicksWithTarget", 100L, 1L, 24000L);
        FARM_ACTION_INTERVAL = BUILDER.comment("The number of ticks that farmers will wait between actions").define("FarmActionInterval", (Object)100);
        BAKING_TIME_REQUIRED_BASELINE = BUILDER.comment("The number of ticks it takes for a villager to bake bread").defineInRange("BakingTimeV2", 1000, 1000, 24000);
        FARMER_WEEDS_RARITY = BUILDER.comment("The chance that a farmer will find weeds (actually grass, for composting) on a still-growing crop block. 1 means \"constantly\".").defineInRange("FarmerWeedsRarity", 1000, 1, 9999);
        SMELTER_WORK_REQUIRED = BUILDER.comment("The number of times a smelter must work on a block of ore to extract the raw materials inside").defineInRange("SmelterWorkRequired", 10, 1, 10);
        GATHERER_TIME_REQUIRED_BASELINE = BUILDER.comment("The number of ticks the gatherer/explorer will spend outside of town collecting items. All villagers will start with this baseline, but it might get altered by villager or town modifiers.").defineInRange("GathererTimeRequiredBaselineV2", 2000, 1, 24000);
        GATHERER_QUARTER_DAY_LOOT_AMOUNT = BUILDER.comment("The number of items generated by gatherer when they return after 1/4 day way").defineInRange("GathererQuarterDayLootAmount", 1, 1, 6);
        GATHERER_HALF_DAY_LOOT_AMOUNT = BUILDER.comment("The number of items generated by gatherer when they return after 1/4 day way").defineInRange("GathererHalfDayLootAmount", 3, 1, 6);
        GATHERER_FULL_DAY_LOOT_AMOUNT = BUILDER.comment("The number of items generated by gatherer when they return after 1/4 day way").defineInRange("GathererFullDayLootAmount", 6, 1, 6);
        JOB_BOARD_ENABLED = BUILDER.comment("Experimental: Villagers will choose work based on the items the player has selected at a \"job board\" registered in the town.").define("JobBoardEnabled", true);
        WORK_SEEKER_COOLDOWN = BUILDER.comment("The number of ticks a WorkSeeker will pause for after finding zero available jobs. Helps avoid wasted CPU and excessive sound effects.").defineInRange("WorkSeekerCooldown", 200L, 1L, 24000L);
        WORKED_RECENTLY_TICKS = BUILDER.comment("The number of ticks after working where a villager will be considered 'worked recently'. Used for navigation logic. This number is in addition to the cooldown_ticks.").defineInRange("WorkedRecentlyTicks", 20L, 1L, 24000L);
        PREFERRED_JOB_ACCEPTANCE = BUILDER.comment("A percentage representing the preferred number of job states that are currently possible. For example, if a job has four states but only three can be done (due to missing tools, etc) then the percentage is 0.75.  This setting determines the minimum acceptable percentage for a villager to even consider trying the work.").defineInRange("PreferredJobAcceptance", 0.65, 0.0, 1.0);
        MIN_JOB_ACCEPTANCE = BUILDER.comment("A percentage representing the minimum number of job states that are currently possible. For example, if a job has four states but only three can be done (due to missing tools, etc) then the percentage is 0.75.  This setting determines the minimum acceptable percentage for a villager to even consider trying the work.").defineInRange("MinJobAcceptance", 0.25, 0.0, 1.0);
        CRASH_ON_INVALID_JOBS = BUILDER.comment("If enabled, questown will crash the server when an invalid job definition is detected. If disabled, it just means those invalid jobs may not function correctly.").define("CrashOnInvalidJobs", true);
        WORK_PRECOMPUTE_FREQUENCY = BUILDER.comment("Questown tries to pre-compute the work that can be picked up by villagers in advance. This controls how many ticks are between attempts.").defineInRange("WorkPrecomputeFrequency", 50L, 1L, 24000L);
        BUILDER.pop();
        BUILDER.push("Villagers");
        MAX_DOWNTIME_TICKS = BUILDER.comment("The number of ticks that a villager will spend on downtime before they decide to go back to work").defineInRange("MaxDowntimeTicks", 1000L, 1L, 24000L);
        MAX_TICKS_BETWEEN_DOWNTIME = BUILDER.comment("The minimum number of ticks that a villager may work constantly before stopping to relax").defineInRange("MaxTicksBetweenDowntime", 4000L, 1L, 24000L);
        WANDER_GIVEUP_TICKS = BUILDER.comment("The limit of time that villagers will spend trying to reach their next destination").defineInRange("WanderGiveUpTicks", 2000, 1, 24000);
        VILLAGER_DISTRACT_DURATION = BUILDER.comment("The number of ticks that a villager will be distracted by (i.e. look at) a nearby entity").defineInRange("VillagerDistractDurationV0.2", 100L, 1L, 24000L);
        VILLAGER_DISTRACT_COOLDOWN = BUILDER.comment("The number of ticks that a villager will avoid being re-distracted by the same entity").defineInRange("VillagerDistractCooldownV0.1", 200L, 1L, 24000L);
        BASE_FULLNESS = BUILDER.comment("The amount of fullness that a typical villager starts with. Fullness ticks down throughout the day. When it reaches zero, the villager will seek out food.").defineInRange("BaseFullness", 5000, 1, 24000);
        HUNGER_ENABLED = BUILDER.comment("Enables a hunger system. Villagers will get more hungry throughout the day and, upon reaching zero, will switch their job to \"dining\" and seek out a dining room to eat in.").define("HungerEnabledV2", false);
        MAX_TICKS_WITHOUT_DINING_TABLE = BUILDER.comment("The maximum number of ticks that a hungry villager will spend trying to find a dinner plate to eat at. After these ticks expire, they will go to the town flag to eat - they will receive a work penalty for eating uncomfortably.").defineInRange("MaxTicksWithoutDiningTableV2", 200L, 1L, 24000L);
        DAMAGE_TICKS = BUILDER.comment("The number of ticks that it will take for one point of damage to heal when no effects are present").defineInRange("DamageTicks", 1000L, 1L, 24000L);
        BUILDER.push("Leveling");
        EXPERIENCE_REQUIRED_AT_LEVEL_1 = BUILDER.comment("The amount of work which must be done to progress from level 1 to level 2").defineInRange("Level1ExperienceRequired", 1000, 1, Integer.MAX_VALUE);
        EXPERIENCE_RAMP_FACTOR = BUILDER.comment("The degree to which more experience is required as the villagers level up").comment("When set to 1.2: Level 2 will require 1200 (1000 * 1.2), Level 3 will require 1440 (1200 * 1.2), and so on...").defineInRange("ExperienceRampFactor", 1.2, 0.1, Double.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("Moods");
        MOOD_TICK_INTERVAL = BUILDER.comment("How often (in ticks) the game will assess a villagers mood effects to determine their overall \"mood\"").defineInRange("MoodTickInterval", 10L, 1L, 24000L);
        NEUTRAL_MOOD = BUILDER.comment("The default mood level for villagers who have no active mood effects").defineInRange("NeutralMood", 75, 0, 100);
        BUILDER.push("EffectDuration");
        MOOD_EFFECT_DURATION_ATE_UNCOMFORTABLY = BUILDER.comment("When villagers eat uncomfortably").defineInRange("AteUncomfortably", 3000L, 0L, 24000L);
        MOOD_EFFECT_DURATION_ATE_COMFORTABLY = BUILDER.comment("When villagers eat comfortably").defineInRange("AteComfortably", 3000L, 0L, 24000L);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Blocks");
        NORMAL_BED_HEAL_MULTIPLIER = BUILDER.comment("How much faster a villager will heal damage from sleeping in a hospital bed instead of standing/walking/working").defineInRange("HospitalBedHealMultiplier", 1.5, 0.5, 100.0);
        HOSPITAL_BED_HEAL_MULTIPLIER = BUILDER.comment("How much faster a villager will heal damage from sleeping in a hospital bed instead of standing/walking/working").defineInRange("HospitalBedHealMultiplier", 2.0, 0.5, 100.0);
        BUILDER.pop();
        BUILDER.push("Advanced");
        BASE_MAX_LOOP = BUILDER.comment("The maximum number of attempts this mod will allow for ANY algorithm. This helps prevent bugs from causing the game to freeze.").defineInRange("BaseMaxLoop", 1000, 1, Integer.MAX_VALUE);
        TICK_SAMPLING_RATE = BUILDER.comment("For profiling minecraft server performance. 0 means OFF and may reduce log bloat.").defineInRange("TickSamplingRate", 0, 0, 24000);
        FLAG_SUB_BLOCK_RETENTION_TICKS = BUILDER.comment("To prevent confusion due to orphaning, blocks like job boards and welcome mats are removed when their flag is destroyed.").defineInRange("FlagSubBlockRetentionTicks", 20, 1, 1000);
        FLAG_SUB_BLOCK_REMOVED_TICKS = BUILDER.comment("The town flag handles dropping the items for sub blocks that are removed. This is the number of ticks it takes to decide that a sub block is gone.").defineInRange("FlagSubBlockRemovedTicks", 2, 1, 1000);
        FLAG_SUB_BLOCK_DETECTION_TICKS = BUILDER.comment("It may take a few ticks before the entity for the sub block shows up in the world. If the number exceeds this config value, the server will crash.").defineInRange("FlagSubBlockDetectionTicks", 100, 1, 1000);
        META_ROOM_DIAMETER = BUILDER.comment("The radius of \"Meta-Rooms\" that exist around points of interest in the town. E.g.There is a meta room around the town flag itself, and one around each welcome mat").defineInRange("MetaRoomDiameter", 2, 1, 100);
        BLOCK_CLAIMS_TICK_LIMIT = BUILDER.comment("If a job claims a block. It will hold that claim for this many ticks. (Or until they finish their work, whatever happens first)").defineInRange("BlockClaimsTickLimit", 1000L, 1L, 24000L);
        FLAG_TICK_INTERVAL = BUILDER.comment("The number of game ticks that pass for every tick that the town flag does").defineInRange("FlagTickInterval", 10L, 1L, 24000L);
        ECONOMIC_RECORDS_DEPTH = BUILDER.comment("This essentially controls how \"far back\" the data goes on the \"Economics\" screens.").defineInRange("FlagTickInterval", 100, 1, 24000);
        BUILDER.push("TimeWarp").comment("Villages do a 'time warp' when the player returns from away - to simulate villager activity. This is an experimental feature.");
        CRASH_ON_FAILED_WARP = BUILDER.comment("Since this is an experimental feature that is likely to crash. By default, problems will be ignored at the cost of lost village productivity.").define("CrashOnFailure", false);
        TIME_WARP_MAX_TICKS = BUILDER.comment("Since the player can be gone for a very long time, we enforce a maximum warp to prevent the warp taking too long to compute.").defineInRange("MaxTicks", 200000, 1, Integer.MAX_VALUE);
        LOG_WARP_RESULT = BUILDER.comment("Set true to enable logging of the town state after a time warp. This produces a large log message and may cause lag.").define("LogWarpResult", false);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Cheats");
        INFINITE_TOWN_DOORS = BUILDER.comment("CHEAT: To make town-building easier, town doors can be made non-consumable.").define("InfiniteTownDoors", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

