/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.advancements;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class RoomTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("questown", "room_trigger");

    public void triggerForNearestPlayer(ServerLevel level, Triggers triggers, BlockPos nearPos) {
        Player np = level.m_45924_((double)nearPos.m_123341_(), (double)nearPos.m_123342_(), (double)nearPos.m_123343_(), 8.0, false);
        if (!(np instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)np;
        this.trigger(sp, triggers);
    }

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject json, EntityPredicate.Composite predicate, DeserializationContext parser) {
        if (!json.has("context")) {
            throw new IllegalStateException(String.format("Trigger of type %s is missing context [ID: %s]", ID, parser.m_25873_()));
        }
        return new Instance(predicate, Triggers.fromJSON(json.get("context")));
    }

    protected void m_66234_(ServerPlayer p_235959_1_, Predicate<Instance> p_235959_2_) {
        super.m_66234_(p_235959_1_, p_235959_2_);
    }

    public void trigger(ServerPlayer player, Triggers trickID) {
        super.m_66234_(player, instance -> instance.matches(trickID));
    }

    public static enum Triggers {
        Invalid,
        FirstRoom,
        FirstJobBlock,
        FirstJobBoard,
        FirstStoreRoom,
        FirstWelcomeMat,
        WandGet,
        FirstOpenFlagMenu;

        private static final BiMap<Triggers, String> stringVals;

        public static Triggers fromJSON(JsonElement trick_id) {
            String key = trick_id.getAsString();
            if (!stringVals.inverse().containsKey((Object)key)) {
                throw new IllegalArgumentException(String.format("Room trigger ID is unexpected: %s", trick_id));
            }
            return (Triggers)((Object)stringVals.inverse().get((Object)key));
        }

        public String getID() {
            return (String)stringVals.get((Object)this);
        }

        static {
            stringVals = ImmutableBiMap.of((Object)((Object)FirstRoom), (Object)"first_room", (Object)((Object)FirstJobBlock), (Object)"first_job_block", (Object)((Object)FirstJobBoard), (Object)"first_job_board", (Object)((Object)FirstStoreRoom), (Object)"first_store_room", (Object)((Object)FirstWelcomeMat), (Object)"first_welcome_mat", (Object)((Object)WandGet), (Object)"wand_get", (Object)((Object)FirstOpenFlagMenu), (Object)"first_open_flag_menu");
        }
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final Triggers context;

        public Instance(EntityPredicate.Composite p_i231464_2_, Triggers context) {
            super(ID, p_i231464_2_);
            if (Triggers.Invalid.equals((Object)context)) {
                throw new IllegalArgumentException("context must not be invalid");
            }
            this.context = context;
        }

        public boolean matches(Triggers trickID) {
            return this.context.equals((Object)trickID);
        }
    }
}

