/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.init;

import ca.bradj.questown.Questown;
import ca.bradj.questown.town.quests.MCDelayedReward;
import ca.bradj.questown.town.quests.MCInstantReward;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.MCRewardList;
import ca.bradj.questown.town.rewards.AddBatchOfQuestsForVisitorReward;
import ca.bradj.questown.town.rewards.AddItemQuestReward;
import ca.bradj.questown.town.rewards.AddRandomJobQuestReward;
import ca.bradj.questown.town.rewards.AddRandomUpgradeQuest;
import ca.bradj.questown.town.rewards.ChangeJobReward;
import ca.bradj.questown.town.rewards.Registry;
import ca.bradj.questown.town.rewards.RewardType;
import ca.bradj.questown.town.rewards.SpawnVisitorReward;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class RewardsInit {
    private static final RewardsInit INSTANCE = new RewardsInit();
    public static final DeferredRegister<RewardType<?>> REWARD_TYPES = DeferredRegister.create(Registry.Keys.REWARD_TYPES, (String)"questown");
    public static final RegistryObject<RewardType<MCRewardList>> LIST = REWARD_TYPES.register("list", () -> RewardType.Builder.of((x$0, x$1) -> new MCRewardList(x$0, x$1, new MCReward[0])).build(Questown.ResourceLocation("list")));
    public static final RegistryObject<RewardType<MCDelayedReward>> DELAYED = REWARD_TYPES.register("delayed", () -> RewardType.Builder.of(MCDelayedReward::new).build(Questown.ResourceLocation("delayed")));
    public static final RegistryObject<RewardType<MCInstantReward>> INSTANT = REWARD_TYPES.register("instant", () -> RewardType.Builder.of(MCInstantReward::new).build(Questown.ResourceLocation("instant")));
    public static final RegistryObject<RewardType<SpawnVisitorReward>> VISITOR = REWARD_TYPES.register("spawn_visitor_reward", () -> RewardType.Builder.of((rType, flag) -> new SpawnVisitorReward(rType, flag, null)).build(Questown.ResourceLocation("spawn_visitor_reward")));
    public static final RegistryObject<RewardType<AddBatchOfQuestsForVisitorReward>> RANDOM_BATCH_FOR_VILLAGER = REWARD_TYPES.register("add_random_batch_of_quests", () -> RewardType.Builder.of((rType, flag) -> new AddBatchOfQuestsForVisitorReward(rType, flag, null)).build(Questown.ResourceLocation("add_random_batch_of_quests")));
    public static final RegistryObject<RewardType<AddRandomUpgradeQuest>> RANDOM_UPGRADE_FOR_VILLAGER = REWARD_TYPES.register("add_random_upgrade_quest", () -> RewardType.Builder.of((rType, flag) -> new AddRandomUpgradeQuest((RewardType<? extends MCReward>)rType, flag, INSTANCE)).build(Questown.ResourceLocation("add_random_upgrade_quest")));
    public static final RegistryObject<RewardType<AddRandomJobQuestReward>> RANDOM_JOB_FOR_VILLAGER = REWARD_TYPES.register("add_random_job_quest", () -> RewardType.Builder.of((rType, flag) -> new AddRandomJobQuestReward((RewardType<? extends MCReward>)rType, flag, INSTANCE)).build(Questown.ResourceLocation("add_random_job_quest")));
    public static final RegistryObject<RewardType<ChangeJobReward>> CHANGE_JOB = REWARD_TYPES.register("change_job", () -> RewardType.Builder.of((rType, flag) -> new ChangeJobReward(rType, flag, null, null)).build(Questown.ResourceLocation("change_job")));
    public static final RegistryObject<RewardType<AddItemQuestReward>> ITEM_QUEST = REWARD_TYPES.register("add_item_quest_reward", () -> RewardType.Builder.of(AddItemQuestReward::emptyForDeserializing).build(Questown.ResourceLocation("add_item_quest_reward")));

    private RewardsInit() {
    }

    public static void register(IEventBus bus) {
        REWARD_TYPES.register(bus);
    }
}

