/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.advancements.VisitorTrigger;
import ca.bradj.questown.core.init.AdvancementsInit;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.core.network.WorkRequestConfirmMessage;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.WorksBehaviour;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public final class AddWorkFromUIMessage {
    private final Ingredient requested;
    private final BlockPos flagPos;
    private final Action action;

    public AddWorkFromUIMessage(Ingredient requested, BlockPos flagPos, Action action) {
        this.requested = requested;
        this.flagPos = flagPos;
        this.action = action;
    }

    public static boolean canEncode(Ingredient item) {
        try {
            Ingredients.toString(item);
            return true;
        }
        catch (Exception e) {
            QT.GUI_LOGGER.error("Failed to encode ingredient {}: {}", item, e.getMessage());
            return false;
        }
    }

    public static void encode(AddWorkFromUIMessage msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.action().ordinal());
        Ingredients.toNetwork(msg.requested, buffer);
        buffer.m_130064_(msg.flagPos);
    }

    public static AddWorkFromUIMessage decode(FriendlyByteBuf buffer) {
        Action action = Action.values()[buffer.readInt()];
        Ingredient request = Ingredients.fromNetwork(buffer);
        BlockPos flagPos = buffer.m_130135_();
        return new AddWorkFromUIMessage(request, flagPos, action);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            BlockEntity flag = sender.m_9236_().m_7702_(this.flagPos);
            if (!(flag instanceof TownFlagBlockEntity)) {
                QT.GUI_LOGGER.error("No flag at position {}. Work will not be added.", this.flagPos);
                return;
            }
            TownFlagBlockEntity tfbe = (TownFlagBlockEntity)flag;
            switch (this.action) {
                case INQUIRED: {
                    WorksBehaviour.TownData td = tfbe.getTownData();
                    Ingredient result = this.requested;
                    QuestownNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new WorkRequestConfirmMessage((Ingredient)this.requested(), (Map<JobID, ResourceLocation>)ServerJobsRegistry.getAllJobsThatProduce(td, result), tfbe.getTownFlagBasePos()));
                    break;
                }
                case CONFIRMED: {
                    VisitorTrigger.Triggers adv = VisitorTrigger.Triggers.FirstJobRequest;
                    AdvancementsInit.VISITOR_TRIGGER.trigger(((NetworkEvent.Context)ctx.get()).getSender(), adv);
                    tfbe.getWorkHandle().requestWork(Ingredients.asWorkRequest(this.requested));
                    tfbe.openJobsMenu(sender, false);
                    break;
                }
                case REJECTED: {
                    tfbe.openJobsMenu(sender, true);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public Object requested() {
        return this.requested;
    }

    public BlockPos flagPos() {
        return this.flagPos;
    }

    public Action action() {
        return this.action;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AddWorkFromUIMessage that = (AddWorkFromUIMessage)obj;
        return Objects.equals(this.requested, that.requested) && Objects.equals(this.flagPos, that.flagPos) && Objects.equals((Object)this.action, (Object)that.action);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requested, this.flagPos, this.action});
    }

    public String toString() {
        return "AddWorkFromUIMessage[requested=" + String.valueOf(this.requested) + ", flagPos=" + String.valueOf(this.flagPos) + ", action=" + String.valueOf((Object)this.action) + "]";
    }

    public static enum Action {
        INQUIRED,
        CONFIRMED,
        REJECTED;

    }
}

