/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.init.TilesInit;
import ca.bradj.questown.core.network.NetworkCompat;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.network.NetworkEvent;

public record ChangeVillagerJobMessage(int flagX, int flagY, int flagZ, UUID villagerUUID, JobID newJob, boolean announce) {
    public static void encode(ChangeVillagerJobMessage msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.flagX());
        buffer.writeInt(msg.flagY());
        buffer.writeInt(msg.flagZ());
        buffer.m_130077_(msg.villagerUUID());
        NetworkCompat.toNetwork(buffer, msg.newJob());
        buffer.writeBoolean(msg.announce());
    }

    public static ChangeVillagerJobMessage decode(FriendlyByteBuf buffer) {
        int flagX = buffer.readInt();
        int flagY = buffer.readInt();
        int flagZ = buffer.readInt();
        UUID id = buffer.m_130259_();
        JobID job = NetworkCompat.fromNetworkJobID(buffer);
        boolean announce1 = buffer.readBoolean();
        return new ChangeVillagerJobMessage(flagX, flagY, flagZ, id, job, announce1);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            Optional flag = sender.m_9236_().m_141902_(new BlockPos(this.flagX, this.flagY, this.flagZ), (BlockEntityType)TilesInit.TOWN_FLAG.get());
            if (flag.isEmpty()) {
                QT.GUI_LOGGER.error("No flag at position {}, {}, {}. Quest will not be removed.", this.flagX, this.flagY, this.flagZ);
                return;
            }
            ((TownFlagBlockEntity)flag.get()).getVillagerHandle().changeJobForVillager(this.villagerUUID, this.newJob, this.announce);
        });
        ctx.get().setPacketHandled(true);
    }
}

