/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.init.TilesInit;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.network.NetworkEvent;

public record GiveBOPMessage(BlockPos flagPos) {
    public static void encode(GiveBOPMessage msg, FriendlyByteBuf buffer) {
        buffer.m_130064_(msg.flagPos);
    }

    public static GiveBOPMessage decode(FriendlyByteBuf buffer) {
        BlockPos flagPos = buffer.m_130135_();
        return new GiveBOPMessage(flagPos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            Optional flag = sender.m_9236_().m_141902_(this.flagPos, (BlockEntityType)TilesInit.TOWN_FLAG.get());
            if (flag.isEmpty()) {
                QT.GUI_LOGGER.error("No flag at position {}. Quest will not be removed.", this.flagPos);
                return;
            }
            ((TownFlagBlockEntity)flag.get()).ejectBlockOfProgress(sender);
        });
        ctx.get().setPacketHandled(true);
    }
}

