/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.init.TilesInit;
import ca.bradj.questown.gui.FlagTabsEmbedding;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.network.NetworkEvent;

public record OpenFlagMenuMessage(FlagTabsEmbedding.FlagInfo flag, String type) {
    public static final String QUESTS = "quests";
    public static final String VILLAGERS = "villagers";
    public static final String ECONOMICS = "economics";
    public static final String BOP = "blocks_of_progress";

    public static void encode(OpenFlagMenuMessage msg, FriendlyByteBuf buffer) {
        buffer.m_130064_(msg.flag.flagPos());
        buffer.m_130070_(msg.type());
        buffer.writeBoolean(msg.flag.showBlockOfProgressTab());
    }

    public static OpenFlagMenuMessage decode(FriendlyByteBuf buffer) {
        BlockPos flag = buffer.m_130135_();
        String type = buffer.m_130277_();
        boolean show = buffer.readBoolean();
        return new OpenFlagMenuMessage(FlagTabsEmbedding.FlagInfo.dumb(flag, show), type);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            BlockPos p = this.flag().flagPos();
            Optional entity = sender.m_9236_().m_141902_(p, (BlockEntityType)TilesInit.TOWN_FLAG.get());
            if (entity.isEmpty()) {
                QT.GUI_LOGGER.error("No flag at position {}, {}, {}. Quest will not be removed.", p.m_123341_(), p.m_123342_(), p.m_123343_());
                return;
            }
            ((TownFlagBlockEntity)entity.get()).menus.showUI(sender, this.type(), this.flag(), ((TownFlagBlockEntity)entity.get()).getBlocksOfProgress());
        }).exceptionally(ex -> {
            QT.GUI_LOGGER.error("Failed to open flag menu", ex);
            return null;
        });
        ctx.get().setPacketHandled(true);
    }
}

