/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.init.TilesInit;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.network.NetworkEvent;

public record OpenItemJobsMessage(BlockPos flagPos, Ingredient itemToShowJobsFor) {
    public static void encode(OpenItemJobsMessage msg, FriendlyByteBuf buffer) {
        buffer.m_130064_(msg.flagPos);
        buffer.m_130070_(Ingredients.toString(msg.itemToShowJobsFor()));
    }

    public static OpenItemJobsMessage decode(FriendlyByteBuf buffer) {
        BlockPos flagPos = buffer.m_130135_();
        Ingredient ing = Ingredients.fromString(buffer.m_130277_());
        return new OpenItemJobsMessage(flagPos, ing);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            Optional flag = sender.m_9236_().m_141902_(this.flagPos, (BlockEntityType)TilesInit.TOWN_FLAG.get());
            if (flag.isEmpty()) {
                QT.GUI_LOGGER.error("No flag at position {}. Quest will not be removed.", this.flagPos);
                return;
            }
            ((TownFlagBlockEntity)flag.get()).getVillagerHandle().showItemJobsUI(sender, this.itemToShowJobsFor);
        });
        ctx.get().setPacketHandled(true);
    }
}

