/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.core.network.NetworkCompat;
import ca.bradj.questown.core.network.ToClientMessage;
import ca.bradj.questown.gui.ClientAccess;
import ca.bradj.questown.jobs.JobID;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public final class OpenVillagerAdvancementsMenuMessage {
    private final BlockPos flagPos;
    private final UUID villagerUUID;
    private final Collection<JobID> unlockedJobs;
    private final Collection<JobID> unlockableJobs;
    private final JobID currentJob;
    private final boolean showBlockOfProgressTab;

    public OpenVillagerAdvancementsMenuMessage(BlockPos flagPos, UUID villagerUUID, Collection<JobID> unlockedJobs, Collection<JobID> unlockableJobs, JobID currentJob, boolean showBlockOfProgressTab) {
        this.flagPos = flagPos;
        this.villagerUUID = villagerUUID;
        this.unlockedJobs = unlockedJobs;
        this.unlockableJobs = unlockableJobs;
        this.currentJob = currentJob;
        this.showBlockOfProgressTab = showBlockOfProgressTab;
    }

    public static void encode(OpenVillagerAdvancementsMenuMessage msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.flagPos.m_123341_());
        buffer.writeInt(msg.flagPos.m_123342_());
        buffer.writeInt(msg.flagPos.m_123343_());
        buffer.m_130077_(msg.villagerUUID);
        buffer.m_236828_(msg.unlockedJobs, NetworkCompat::toNetwork);
        buffer.m_236828_(msg.unlockableJobs, NetworkCompat::toNetwork);
        NetworkCompat.toNetwork(buffer, msg.currentJob());
        buffer.writeBoolean(msg.showBlockOfProgressTab);
    }

    public static OpenVillagerAdvancementsMenuMessage decode(FriendlyByteBuf buffer) {
        return new OpenVillagerAdvancementsMenuMessage(new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt()), buffer.m_130259_(), buffer.m_236845_(NetworkCompat::fromNetworkJobID), buffer.m_236845_(NetworkCompat::fromNetworkJobID), NetworkCompat.fromNetworkJobID(buffer), buffer.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ToClientMessage.handle(ctx, () -> ClientAccess.openVillagerAdvancements(this.flagPos, this.villagerUUID, this.unlockedJobs, this.unlockableJobs, this.currentJob, this.showBlockOfProgressTab));
    }

    public BlockPos flagPos() {
        return this.flagPos;
    }

    public UUID villagerUUID() {
        return this.villagerUUID;
    }

    public JobID currentJob() {
        return this.currentJob;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        OpenVillagerAdvancementsMenuMessage that = (OpenVillagerAdvancementsMenuMessage)obj;
        return Objects.equals(this.flagPos, that.flagPos) && Objects.equals(this.villagerUUID, that.villagerUUID) && Objects.equals(this.unlockedJobs, that.unlockedJobs) && Objects.equals(this.currentJob, that.currentJob);
    }

    public int hashCode() {
        return Objects.hash(this.flagPos, this.villagerUUID, this.unlockedJobs, this.currentJob);
    }

    public String toString() {
        return "OpenVillagerAdvancementsMenuMessage[flagPos=" + String.valueOf(this.flagPos) + ", villagerUUID=" + String.valueOf(this.villagerUUID) + ", unlockedJobs=" + String.valueOf(this.unlockedJobs) + ", currentJob=" + String.valueOf(this.currentJob) + "]";
    }
}

