/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.init.TilesInit;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.network.NetworkEvent;

public record RemoveQuestFromUIMessage(UUID questIndex, int flagX, int flagY, int flagZ, boolean promptForConfirmation) {
    public static void encode(RemoveQuestFromUIMessage msg, FriendlyByteBuf buffer) {
        buffer.m_130077_(msg.questIndex);
        buffer.writeInt(msg.flagX);
        buffer.writeInt(msg.flagY);
        buffer.writeInt(msg.flagZ);
        buffer.writeBoolean(msg.promptForConfirmation);
    }

    public static RemoveQuestFromUIMessage decode(FriendlyByteBuf buffer) {
        UUID questIndex = buffer.m_130259_();
        int flagX = buffer.readInt();
        int flagY = buffer.readInt();
        int flagZ = buffer.readInt();
        boolean prompt = buffer.readBoolean();
        return new RemoveQuestFromUIMessage(questIndex, flagX, flagY, flagZ, prompt);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            Optional flag = sender.m_9236_().m_141902_(new BlockPos(this.flagX, this.flagY, this.flagZ), (BlockEntityType)TilesInit.TOWN_FLAG.get());
            if (flag.isEmpty()) {
                QT.GUI_LOGGER.error("No flag at position {}, {}, {}. Quest will not be removed.", this.flagX, this.flagY, this.flagZ);
                return;
            }
            ((TownFlagBlockEntity)flag.get()).getQuestHandle().requestRemovalOfQuestAtIndex(this.questIndex, sender, this.promptForConfirmation);
        });
        ctx.get().setPacketHandled(true);
    }
}

