/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.init.TilesInit;
import ca.bradj.questown.jobs.requests.WorkRequest;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.network.NetworkEvent;

public record RemoveWorkFromUIMessage(WorkRequest requested, int flagX, int flagY, int flagZ) {
    public static void encode(RemoveWorkFromUIMessage msg, FriendlyByteBuf buffer) {
        msg.requested.toNetwork(buffer);
        buffer.writeInt(msg.flagX);
        buffer.writeInt(msg.flagY);
        buffer.writeInt(msg.flagZ);
    }

    public static RemoveWorkFromUIMessage decode(FriendlyByteBuf buffer) {
        WorkRequest requested = WorkRequest.fromNetwork(buffer);
        int flagX = buffer.readInt();
        int flagY = buffer.readInt();
        int flagZ = buffer.readInt();
        return new RemoveWorkFromUIMessage(requested, flagX, flagY, flagZ);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            Optional flag = sender.m_9236_().m_141902_(new BlockPos(this.flagX, this.flagY, this.flagZ), (BlockEntityType)TilesInit.TOWN_FLAG.get());
            if (flag.isEmpty()) {
                QT.GUI_LOGGER.error("No flag at position {}, {}, {}. Work will not be added.", this.flagX, this.flagY, this.flagZ);
                return;
            }
            ((TownFlagBlockEntity)flag.get()).getWorkHandle().removeWorkRequest(this.requested);
            ((TownFlagBlockEntity)flag.get()).openJobsMenu(sender, false);
        });
        ctx.get().setPacketHandled(true);
    }
}

