/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.init.TilesInit;
import ca.bradj.questown.gui.BopTransactionSyncer;
import ca.bradj.questown.gui.JobUnlockConfirmMenu;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public record UnlockJobMessage(BlockPos flagPos, UUID villagerUUID, JobID id, boolean confirmFirst) {
    public static void encode(UnlockJobMessage msg, FriendlyByteBuf buffer) {
        buffer.m_130064_(msg.flagPos);
        buffer.m_130077_(msg.villagerUUID);
        Jobs.writeIdToNetwork(buffer, msg.id);
        buffer.writeBoolean(msg.confirmFirst);
    }

    public static UnlockJobMessage decode(FriendlyByteBuf buffer) {
        BlockPos flagPos = buffer.m_130135_();
        UUID uuid = buffer.m_130259_();
        JobID jobId = Jobs.getIdFromNetwork(buffer);
        return new UnlockJobMessage(flagPos, uuid, jobId, buffer.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            Optional flag = sender.m_9236_().m_141902_(this.flagPos, (BlockEntityType)TilesInit.TOWN_FLAG.get());
            if (flag.isEmpty()) {
                QT.GUI_LOGGER.error("No flag at position {}. Quest will not be removed.", this.flagPos);
                return;
            }
            if (this.confirmFirst) {
                Compat.openScreen(sender, new MenuProvider(){

                    @Nullable
                    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
                        return new JobUnlockConfirmMenu(i, (Container)new SimpleContainer(1){

                            public int m_6893_() {
                                return 1;
                            }
                        }, inventory, UnlockJobMessage.this.villagerUUID, UnlockJobMessage.this.id, UnlockJobMessage.this.flagPos);
                    }

                    public Component m_5446_() {
                        return Compat.literal("");
                    }
                }, data -> JobUnlockConfirmMenu.ToNetwork(data, this.villagerUUID, this.id, this.flagPos));
                return;
            }
            BopTransactionSyncer.syncConsumedBOP(sender);
            this.unlockJob(flag, sender);
        });
        ctx.get().setPacketHandled(true);
    }

    private void unlockJob(Optional<TownFlagBlockEntity> flag, ServerPlayer sender) {
        flag.get().getVillagerHandle().unlockJob(this.villagerUUID, this.id);
        String key = "messages.jobs.unlocked_by_mod";
        MutableComponent msg = Compat.translatable(key, sender.m_7755_(), this.id.toNiceString(), this.villagerUUID);
        for (Player player : sender.f_19853_.m_6907_()) {
            Compat.sendMessage((ServerPlayer)player, (Component)msg);
        }
    }
}

