/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.core.network;

import ca.bradj.questown.core.network.ClientRunnable;
import ca.bradj.questown.core.network.NetworkCompat;
import ca.bradj.questown.core.network.ToClientMessage;
import ca.bradj.questown.gui.ClientAccess;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.jobs.JobID;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.network.NetworkEvent;

public record WorkRequestConfirmMessage(Ingredient itemRequested, Map<JobID, ResourceLocation> iconsForJobsWhichProduceResult, BlockPos flagPos) implements ClientRunnable
{
    public static void encode(WorkRequestConfirmMessage msg, FriendlyByteBuf buffer) {
        Ingredients.toNetwork(msg.itemRequested(), buffer);
        buffer.m_236831_(msg.iconsForJobsWhichProduceResult(), NetworkCompat::toNetwork, FriendlyByteBuf::m_130085_);
        buffer.m_130064_(msg.flagPos());
    }

    public static WorkRequestConfirmMessage decode(FriendlyByteBuf buffer) {
        Ingredient itemRequested = Ingredients.fromNetwork(buffer);
        Map l = buffer.m_236847_(NetworkCompat::fromNetworkJobID, FriendlyByteBuf::m_130281_);
        BlockPos flagPos = buffer.m_130135_();
        return new WorkRequestConfirmMessage(itemRequested, (Map<JobID, ResourceLocation>)ImmutableMap.copyOf((Map)l), flagPos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ToClientMessage.handle(ctx, this);
    }

    @Override
    public void runOnClient() {
        ClientAccess.openWorkRequestConfirm(this.itemRequested, this.iconsForJobsWhichProduceResult, this.flagPos);
    }
}

