/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.QT;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVillagerMenu
extends AbstractContainerMenu {
    protected final BlockPos flagPos;
    protected final UUID villagerUUID;
    private final InvWrapper gathererInventory;
    protected final InvWrapper playerInventory;
    private static final int inventoryLeftX = 8;
    private static final int boxHeight = 18;
    protected int gathererInventoryYOffset = 18;
    private static final int boxWidth = 18;
    private static final int margin = 4;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;

    protected AbstractVillagerMenu(@Nullable MenuType<?> p_38851_, @Nullable Container villagerInventory, @Nullable Inventory playerInventory, int p_38852_, BlockPos flagPos, UUID villagerUUID) {
        super(p_38851_, p_38852_);
        this.flagPos = flagPos;
        this.villagerUUID = villagerUUID;
        this.gathererInventory = new InvWrapper(villagerInventory);
        this.playerInventory = new InvWrapper((Container)playerInventory);
    }

    public BlockPos getFlagPos() {
        return this.flagPos;
    }

    public UUID getVillagerUUID() {
        return this.villagerUUID;
    }

    public boolean m_6875_(Player p_38874_) {
        return true;
    }

    protected final void layoutSlots(Container gathererInv) {
        this.layoutPlayerInventorySlots(86);
        this.layoutGathererInventorySlots(this.gathererInventoryYOffset, gathererInv.m_6643_());
    }

    protected void layoutGathererInventorySlots(int pixelsFromTop, int numSlots) {
        this.addLineOfBoxes((IItemHandler)this.gathererInventory, 0, 8, pixelsFromTop, numSlots);
    }

    protected void layoutPlayerInventorySlots(int pixelsFromTop) {
        int rectangleRows = 3;
        this.addRectangleOfBoxes((IItemHandler)this.playerInventory, 9, 8, pixelsFromTop, 9, rectangleRows);
        this.addLineOfBoxes((IItemHandler)this.playerInventory, 0, 8, pixelsFromTop += 18 * rectangleRows + 4, 9);
    }

    protected void addRectangleOfBoxes(IItemHandler handler, int inventoryIndex, int leftX, int topY, int xBoxes, int yBoxes) {
        int y = topY;
        int nextInvIndex = inventoryIndex;
        for (int j = 0; j < yBoxes; ++j) {
            this.addLineOfBoxes(handler, nextInvIndex, leftX, y, xBoxes);
            nextInvIndex += xBoxes;
            y += 18;
        }
    }

    protected void addLineOfBoxes(IItemHandler handler, int index, int leftX, int topY, int numBoxes) {
        if (numBoxes <= 0) {
            QT.VILLAGER_LOGGER.error("Adding line of boxes with size zero. This is probably a bug.", new Object[0]);
        }
        int x = leftX;
        int nextInvIndex = index;
        for (int i = 0; i < numBoxes; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, nextInvIndex, x, topY));
            ++nextInvIndex;
            x += 18;
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        int upperBound = 36 + this.gathererInventory.getSlots();
        if (index < 36) {
            int lowerBound = 36;
            if (!this.moveItemStackTo(sourceStack, lowerBound, upperBound)) {
                return ItemStack.f_41583_;
            }
        } else if (index < upperBound) {
            if (!this.moveItemStackTo(sourceStack, 0, 36)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, copyOfSourceStack);
        return copyOfSourceStack;
    }

    protected boolean m_38903_(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        return this.moveItemStackTo(p_38904_, p_38905_, p_38906_);
    }

    protected boolean moveItemStackTo(ItemStack p_38904_, int p_38905_, int p_38906_) {
        boolean flag = false;
        int i = p_38905_;
        ArrayList<Slot> updated = new ArrayList<Slot>();
        if (!p_38904_.m_41619_()) {
            for (i = p_38905_; i < p_38906_; ++i) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (!itemstack1.m_41619_() || !slot1.m_5857_(p_38904_)) continue;
                if (p_38904_.m_41613_() > slot1.m_6641_()) {
                    slot1.m_5852_(p_38904_.m_41620_(slot1.m_6641_()));
                } else {
                    slot1.m_5852_(p_38904_.m_41620_(p_38904_.m_41613_()));
                }
                updated.add(slot1);
                flag = true;
                if (p_38904_.m_41619_()) break;
            }
        }
        for (Slot s : updated) {
            s.m_6654_();
        }
        return flag;
    }

    public abstract void onClose();

    protected ImmutableList<Slot> getVillagerSlots() {
        return ImmutableList.copyOf(this.f_38839_.stream().filter(v -> v.f_40218_.equals(this.gathererInventory)).toList());
    }

    @Nullable
    protected Player getPlayer() {
        Container container = this.playerInventory.getInv();
        if (container instanceof Inventory) {
            Inventory i = (Inventory)container;
            return i.f_35978_;
        }
        return null;
    }

    protected void clearContainer(Player p38940) {
        this.m_150411_(p38940, this.gathererInventory.getInv());
    }
}

