/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.commands.JobArgument;
import ca.bradj.questown.core.Pair;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.gui.ItemJobsScreen;
import ca.bradj.questown.gui.StatusArt;
import ca.bradj.questown.gui.StatusPacket;
import ca.bradj.questown.gui.UIJob;
import ca.bradj.questown.gui.WorkRequestConfirmScreen;
import ca.bradj.questown.gui.villager.advancements.VillagerAdvancementsScreen;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.production.ProductionStatus;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class ClientAccess {
    private static final Map<Pair<JobID, ProductionStatus>, ResourceLocation> artOverrides = new HashMap<Pair<JobID, ProductionStatus>, ResourceLocation>();
    private static final Map<Pair<JobID, ProductionStatus>, ImmutableList<Component>> textOverrides = new HashMap<Pair<JobID, ProductionStatus>, ImmutableList<Component>>();

    public static boolean openVillagerAdvancements(BlockPos flagPos, UUID villagerUUID, Collection<JobID> unlockedJobs, Collection<JobID> unlockableJobs, JobID currentJob, boolean showBlockOfProgressTab) {
        return ClientAccess.openScreen(() -> new VillagerAdvancementsScreen(flagPos, villagerUUID, unlockedJobs, unlockableJobs, currentJob, showBlockOfProgressTab));
    }

    public static void openWorkRequestConfirm(Ingredient itemRequested, Map<JobID, ResourceLocation> iconsForJobsWhichProduceResult, BlockPos flagPos) {
        ClientAccess.openScreen(() -> new WorkRequestConfirmScreen(itemRequested, iconsForJobsWhichProduceResult, flagPos));
    }

    public static void openItemJobs(Ingredient requestedItem, Collection<UIJob> jobs, BlockPos flagPos) {
        ClientAccess.openScreen(() -> new ItemJobsScreen(requestedItem, jobs, flagPos));
    }

    public static void syncJobsForCommands(ImmutableList<JobID> jobs) {
        JobArgument.jobIDs = jobs;
    }

    public static boolean openScreen(Supplier<Screen> screen) {
        Minecraft.m_91087_().m_91152_(screen.get());
        return true;
    }

    public static void showHint(Component c) {
        Minecraft.m_91087_().f_91065_.m_93063_(c, false);
    }

    public static void closeScreens() {
        Minecraft.m_91087_().m_91152_(null);
    }

    public static void storeArtOverride(JobID id, ProductionStatus status, ResourceLocation artID) {
        artOverrides.put(new Pair<JobID, ProductionStatus>(id, status), artID);
    }

    public static ResourceLocation getArt(JobID id, ProductionStatus status) {
        return UtilClean.getOrDefault(artOverrides, new Pair<JobID, ProductionStatus>(id, status), StatusArt.ERROR_TEX);
    }

    public static void storeTextOverride(ProductionStatus status, StatusPacket packet) {
        textOverrides.put(new Pair<JobID, ProductionStatus>(packet.jobId(), status), packet.texts());
    }

    @Nullable
    public static ImmutableList<Component> getStatusText(JobID jobId, ProductionStatus status) {
        return UtilClean.getOrDefault(textOverrides, new Pair<JobID, ProductionStatus>(jobId, status), null);
    }
}

