/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.core.network.OpenFlagMenuMessage;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.gui.FlagTabsEmbedding;
import ca.bradj.questown.gui.RenderContext;
import ca.bradj.questown.gui.RenderUtil;
import ca.bradj.questown.gui.SubUI;
import ca.bradj.questown.gui.Tab;
import ca.bradj.questown.gui.Tabs;
import ca.bradj.questown.mc.Util;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class FlagTabs
extends Tabs
implements SubUI {
    public FlagTabs(@Nullable Runnable questsScreenFn, @Nullable Runnable villagerScreenFn, @Nullable Runnable econScreenFn, @Nullable Runnable bopScreenFn, FlagTabsEmbedding.FlagInfo showBOPTab) {
        super(FlagTabs.build(questsScreenFn, villagerScreenFn, econScreenFn, bopScreenFn, showBOPTab));
    }

    @NotNull
    private static ImmutableList<Tab> build(@Nullable Runnable questsScreenFn, @Nullable Runnable villagerScreenFn, @Nullable Runnable econScreenFn, @Nullable Runnable bopScreenFn, FlagTabsEmbedding.FlagInfo fi) {
        ImmutableList.Builder b = ImmutableList.builder();
        if (fi.showVillagersTab()) {
            b.add((Object)new Tab((TriConsumer<RenderContext, Integer, Integer>)((TriConsumer)(rc, x, y) -> rc.itemRenderer().m_115203_(Items.f_42680_.m_7968_(), x + 10, y + 7)), FlagTabs.setScreen(villagerScreenFn), "tooltips.villagers", villagerScreenFn == null));
        }
        if (fi.showQuestsTab()) {
            b.add((Object)new Tab((TriConsumer<RenderContext, Integer, Integer>)((TriConsumer)(rc, x, y) -> rc.itemRenderer().m_115203_(Items.f_42517_.m_7968_(), x + 10, y + 7)), FlagTabs.setScreen(questsScreenFn), "tooltips.quests", questsScreenFn == null));
        }
        if (fi.showEconTab()) {
            b.add((Object)new Tab((TriConsumer<RenderContext, Integer, Integer>)((TriConsumer)(rc, x, y) -> {
                int txBefore = RenderSystem.m_157203_((int)0);
                Util.blitTab(rc.stack(), x, y, 0);
                RenderSystem.m_157453_((int)0, (int)txBefore);
            }), FlagTabs.setScreen(econScreenFn), "tooltips.economics", econScreenFn == null));
        }
        if (fi.showBlockOfProgressTab()) {
            b.add((Object)new Tab((TriConsumer<RenderContext, Integer, Integer>)((TriConsumer)(rc, x, y) -> RenderUtil.renderItemScaled(rc.itemRenderer(), 2, ((Item)ItemsInit.BLOCK_OF_PROGRESS.get()).m_7968_(), x + 10, y + 7)), FlagTabs.setScreen(bopScreenFn), "tooltips.blocks_of_progress", bopScreenFn == null));
        }
        return b.build();
    }

    private static Runnable setScreen(Runnable s) {
        if (s == null) {
            return () -> {};
        }
        return s;
    }

    public static Runnable makeOpenFn(FlagTabsEmbedding.FlagInfo fp, String type) {
        Runnable fn = () -> QuestownNetwork.CHANNEL.sendToServer((Object)new OpenFlagMenuMessage(fp, type));
        return fn;
    }

    public static FlagTabs forMenu(FlagTabsEmbedding menu) {
        Collection<String> enabledTabs = menu.getEnabledTabs();
        Function<String, Runnable> factory = typ -> {
            if (enabledTabs.contains(typ)) {
                return FlagTabs.makeOpenFn(menu.getFlagInfo(), typ);
            }
            return null;
        };
        return new FlagTabs(factory.apply("quests"), factory.apply("villagers"), factory.apply("economics"), factory.apply("blocks_of_progress"), menu.getFlagInfo());
    }

    public static Collection<String> allExcept(String except) {
        ImmutableList all = ImmutableList.of((Object)"villagers", (Object)"quests", (Object)"economics", (Object)"blocks_of_progress");
        return ImmutableList.copyOf(all.stream().filter(v -> !v.equals(except)).toList());
    }
}

