/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.init.MenuTypesInit;
import ca.bradj.questown.core.network.JobWantedIngredientsMessage;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.core.network.SyncStatusArtMessage;
import ca.bradj.questown.core.network.SyncStatusTextMessage;
import ca.bradj.questown.gui.AbstractTabbedVillagerMenu;
import ca.bradj.questown.gui.SessionUniqueOrdinals;
import ca.bradj.questown.gui.StatusPacket;
import ca.bradj.questown.gui.VillagerMenus;
import ca.bradj.questown.gui.VillagerTabs;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.StatusListener;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class InventoryAndStatusMenu
extends AbstractTabbedVillagerMenu
implements StatusListener {
    private static final Collection<String> ENABLED_TABS = VillagerTabs.except("inventory");
    private static final int boxHeight = 18;
    private final DataSlot statusSlot;
    final JobID jobId;
    private final Stack<Runnable> closers = new Stack();
    private final boolean showBlockOfProgressTab;

    public static InventoryAndStatusMenu ForClientSide(int windowId, Inventory inv, FriendlyByteBuf buf) {
        VillagerMenus menus = VillagerMenus.fromNetwork(windowId, inv.f_35978_, buf);
        return menus.invMenu;
    }

    public <S extends IStatus<S>> InventoryAndStatusMenu(int windowId, Container gathererInv, Inventory inv, Collection<Boolean> slotLocks, UUID villagerUUID, JobID jobId, BlockPos flagPos, boolean showBlockOfProgressTab) {
        super((MenuType)MenuTypesInit.GATHERER_INVENTORY.get(), gathererInv, inv, windowId, flagPos, villagerUUID);
        this.jobId = jobId;
        this.layoutSlots(gathererInv);
        this.statusSlot = DataSlot.m_39401_();
        this.m_38895_(this.statusSlot);
        this.showBlockOfProgressTab = showBlockOfProgressTab;
    }

    @Override
    public boolean m_6875_(Player p_38874_) {
        return true;
    }

    public IStatus<?> getStatus() {
        return SessionUniqueOrdinals.getStatus(this.statusSlot.m_6501_());
    }

    @Override
    public void statusChanged(IStatus<?> newStatus) {
        this.statusSlot.m_6422_(SessionUniqueOrdinals.getOrdinal(newStatus));
        Player player = this.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        ResourceLocation tex = ServerJobsRegistry.getTexture(this.jobId, newStatus);
        @NotNull ImmutableList<Component> text = ServerJobsRegistry.getStatusText(this.jobId, newStatus);
        if (newStatus instanceof ProductionStatus) {
            ProductionStatus ps = (ProductionStatus)newStatus;
            QuestownNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new SyncStatusArtMessage(this.jobId, ps, tex));
            if (text.isEmpty()) {
                return;
            }
            QuestownNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new SyncStatusTextMessage(ps, new StatusPacket(this.jobId, text, tex)));
        }
    }

    public String getRootJobId() {
        return this.jobId.rootId();
    }

    @Override
    public void onClose() {
        this.closers.forEach(Runnable::run);
    }

    @Override
    public Collection<String> getEnabledTabs() {
        return ENABLED_TABS;
    }

    @Override
    public boolean showBlockOfProgressTab() {
        return this.showBlockOfProgressTab;
    }

    public void connectToServer(VisitorMobEntity e, ServerPlayer sender) {
        IStatus<?> status = e.getStatusForServer();
        this.addStatusListener(e, status);
        this.addWantedIngredientsListener(e, sender);
        this.statusChanged(status);
    }

    @Override
    public Runnable jobChanged(Function<StatusListener, Runnable> listenToNewJob) {
        return listenToNewJob.apply(this);
    }

    private void addStatusListener(VisitorMobEntity e, IStatus<?> status) {
        this.statusSlot.m_6422_(SessionUniqueOrdinals.getOrdinal(status));
        e.addStatusListener(this);
        this.closers.add(() -> e.removeStatusListener(this));
    }

    private void addWantedIngredientsListener(VisitorMobEntity e, ServerPlayer sender) {
        JobWantedIngredientsMessage msg = InventoryAndStatusMenu.buildMessage(e);
        PacketDistributor.PacketTarget tgt = PacketDistributor.PLAYER.with(() -> sender);
        Consumer<ImmutableList<Ingredient>> listener = ingr -> QuestownNetwork.CHANNEL.send(tgt, (Object)msg);
        e.addWantedIngredientsListener(listener);
        this.closers.add(() -> e.removeWantedIngredientsListener(listener));
        QuestownNetwork.CHANNEL.send(tgt, (Object)InventoryAndStatusMenu.buildMessage(e));
    }

    @NotNull
    private static JobWantedIngredientsMessage buildMessage(VisitorMobEntity e) {
        Function<List<MCHeldItem>, ImmutableList<Ingredient>> wantFn = ServerJobsRegistry.getWantedResourcesProvider(e.getJobId());
        return new JobWantedIngredientsMessage(wantFn.apply((List<MCHeldItem>)Jobs.getHeldItems(e.getInventory())));
    }
}

