/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.Coordinate;
import ca.bradj.questown.core.network.OpenJobMessage;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.gui.ClientJobWantedResources;
import ca.bradj.questown.gui.IngredientRenderer;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.gui.InventoryAndStatusMenu;
import ca.bradj.questown.gui.RenderContext;
import ca.bradj.questown.gui.StatusGraphic;
import ca.bradj.questown.gui.Tabs;
import ca.bradj.questown.gui.VillagerTabs;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.JEI;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class InventoryAndStatusScreen
extends AbstractContainerScreen<InventoryAndStatusMenu> {
    private static final int backgroundWidth = 176;
    private static final int backgroundHeight = 166;
    private final JEI.NineNine background;
    private final IDrawableStatic slot;
    private final ResourceLocation lockTex;
    private final Tabs tabs;
    private final StatusGraphic status;
    private final IngredientRenderer ingredientRenderer = new IngredientRenderer();

    public InventoryAndStatusScreen(InventoryAndStatusMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.background = JEI.getRecipeGuiBackground();
        this.slot = JEI.getSlotDrawable();
        this.lockTex = new ResourceLocation("questown", "textures/menu/gatherer/locked.png");
        this.tabs = VillagerTabs.forMenu(menu);
        this.status = new StatusGraphic(menu.jobId, () -> new Coordinate((this.f_96543_ - 176) / 2 + 176 - 16 - 32, (this.f_96544_ - 166) / 2 + 16), menu::getStatus);
    }

    public void m_7379_() {
        super.m_7379_();
        ((InventoryAndStatusMenu)this.f_97732_).onClose();
    }

    protected void m_7856_() {
        super.m_7856_();
        int maybeX = this.f_96543_ / 2 + 32;
        int maybeY = (this.f_96544_ - 166) / 2 + 32 + 16 + 8;
        this.m_142416_((GuiEventListener)new Button(maybeX, maybeY, 48, 20, Compat.translatable("menu.quests"), p_96776_ -> this.openQuestsScreen()));
    }

    private void openQuestsScreen() {
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        super.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.m_7025_(stack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - 166) / 2;
        this.background.draw(stack, bgX, bgY, 176, 166);
        this.tabs.draw(new RenderContext(this.f_96542_, stack), bgX, bgY);
        this.renderInventory(stack);
        this.status.render(stack);
    }

    private void renderInventory(PoseStack stack) {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        int yCoord = 0;
        for (int i = 0; i < ((InventoryAndStatusMenu)this.f_97732_).f_38839_.size(); ++i) {
            Slot s = (Slot)((InventoryAndStatusMenu)this.f_97732_).f_38839_.get(i);
            int xCoord = x - 1 + s.f_40220_;
            yCoord = y - 1 + s.f_40221_;
            this.slot.draw(stack, xCoord, yCoord);
        }
        int iconX = x - 8;
        for (Ingredient i : ClientJobWantedResources.wantedIngredients) {
            this.ingredientRenderer.render(this.f_96542_, i, iconX += 16, yCoord + 32);
        }
    }

    private void renderSlotStatus(PoseStack stack, DataSlot dataSlot, int x, int y) {
        if (dataSlot.m_6501_() == 0) {
            return;
        }
        if (dataSlot.m_6501_() != 1) {
            throw new IllegalStateException("Slot status should only be 0 or 1");
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.lockTex);
        boolean srcX = false;
        boolean srcY = false;
        int drawWidth = 16;
        int drawHeight = 8;
        int texWidth = 16;
        int texHeight = 8;
        InventoryAndStatusScreen.m_93133_((PoseStack)stack, (int)x, (int)y, (float)((float)srcX), (float)((float)srcY), (int)drawWidth, (int)drawHeight, (int)texWidth, (int)texHeight);
    }

    protected void m_7025_(@NotNull PoseStack stack, int mouseX, int mouseY) {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        if (this.tabs.renderTooltip(x, y, mouseX, mouseY, key -> super.m_96602_(stack, Compat.translatable(key), mouseX, mouseY))) {
            return;
        }
        if (this.status.renderTooltip(mouseX, mouseY, key -> super.m_169388_(stack, (List)key, Optional.empty(), mouseX, mouseY))) {
            return;
        }
        int yCoord = y - 1;
        for (int i = 0; i < ((InventoryAndStatusMenu)this.f_97732_).f_38839_.size(); ++i) {
            Slot s = (Slot)((InventoryAndStatusMenu)this.f_97732_).f_38839_.get(i);
            int xCoord = x - 1 + s.f_40220_;
            yCoord = y - 1 + s.f_40221_;
            if (i < 36 || !this.renderLocksTooltip(stack, xCoord + 1, yCoord + 16 + 2, mouseX, mouseY)) continue;
            return;
        }
        int iconX = x - 12;
        for (Ingredient i : ClientJobWantedResources.wantedIngredients) {
            if (!this.renderNeedsTooltip(stack, iconX += 20, yCoord + 32, mouseX, mouseY, i)) continue;
            return;
        }
        super.m_7025_(stack, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_97750_) {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        if (this.tabs.mouseClicked(x, y, mouseX, mouseY)) {
            return true;
        }
        if (this.status.mouseClicked((int)mouseX, (int)mouseY)) {
            QuestownNetwork.CHANNEL.sendToServer((Object)new OpenJobMessage(((InventoryAndStatusMenu)this.f_97732_).flagPos, ((InventoryAndStatusMenu)this.f_97732_).jobId));
            return true;
        }
        return super.m_6375_(mouseX, mouseY, p_97750_);
    }

    private boolean renderLocksTooltip(@NotNull PoseStack stack, int leftX, int topY, int mouseX, int mouseY) {
        int rightX = leftX + 16;
        int botY = topY + 8;
        if (mouseX > leftX && mouseX < rightX && mouseY > topY && mouseY < botY) {
            Component component = Compat.translatable("tooltips.villagers.job.inventory.locked");
            super.m_169388_(stack, (List)ImmutableList.of((Object)component), Optional.empty(), mouseX, mouseY);
            return true;
        }
        return false;
    }

    private boolean renderNeedsTooltip(@NotNull PoseStack stack, int leftX, int topY, int mouseX, int mouseY, Ingredient item) {
        int rightX = leftX + 16;
        int botY = topY + 16;
        if (mouseX > leftX && mouseX < rightX && mouseY > topY && mouseY < botY) {
            Component jPart = Compat.translatable(String.format("jobs.%s", ((InventoryAndStatusMenu)this.f_97732_).getRootJobId()));
            MutableComponent component = Compat.translatable("tooltips.villagers.job.needs", jPart, Ingredients.getName(item));
            super.m_169388_(stack, (List)ImmutableList.of((Object)component), Optional.empty(), mouseX, mouseY);
            return true;
        }
        return false;
    }
}

