/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.Coordinate;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.core.network.AddWorkFromUIMessage;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.gui.PagedCardScreen;
import ca.bradj.questown.gui.RenderUtil;
import ca.bradj.questown.gui.UIJob;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.util.BiConsumer;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.api.TriPredicate;

public class ItemJobsScreen
extends Screen {
    public static final int EXTRA_HEIGHT = 56;
    private final List<UIJob> jobs;
    private final PagedCardScreen<UIJob> delegate = new PagedCardScreen<UIJob>(() -> this.f_96544_, () -> this.f_96543_, () -> ImmutableList.copyOf((Collection)jobs), UtilClean::noOpConsumer, this::renderCardContent, 3, 16, 56);
    @NotNull
    private Ingredient requestedItem;
    private final BlockPos flagPos;
    private Button addButton;

    public ItemJobsScreen(Ingredient requestedItem, Collection<UIJob> jobs, BlockPos flagPos) {
        super(Compat.translatable("menu.work_add_confirm.title"));
        this.jobs = ImmutableList.copyOf(jobs);
        this.requestedItem = requestedItem;
        this.flagPos = flagPos;
    }

    private void send() {
        ItemStack first = this.getFirst();
        if (first.m_41619_()) {
            QT.GUI_LOGGER.error("Cannot add work request for job with empty result", new Object[0]);
            return;
        }
        AddWorkFromUIMessage m = new AddWorkFromUIMessage(Ingredient.m_43927_((ItemStack[])new ItemStack[]{first}), this.flagPos, AddWorkFromUIMessage.Action.CONFIRMED);
        QuestownNetwork.CHANNEL.sendToServer((Object)m);
    }

    private ItemStack getFirst() {
        UIJob j = this.jobs.get(this.delegate.getCurrentPageIndex());
        ImmutableList<ItemStack> r = j.result();
        if (r.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack first = (ItemStack)r.get(0);
        if (first.m_41619_()) {
            return ItemStack.f_41583_;
        }
        return first;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 81) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.delegate.afterInit(x$0 -> {
            GuiIconButtonSmall cfr_ignored_0 = (GuiIconButtonSmall)this.m_142416_((GuiEventListener)x$0);
        });
        int pageTopY = (this.f_96544_ - this.delegate.backgroundHeight) / 2;
        int pageLeftX = (this.f_96543_ - 176) / 2;
        Objects.requireNonNull(this.f_96547_);
        int buttonHeight = 2 * 9 + 2;
        this.addButton = (Button)this.m_142416_((GuiEventListener)new Button(pageLeftX + 10, pageTopY + this.delegate.backgroundHeight - buttonHeight - 10, 156, buttonHeight, Compat.translatable("menu.item_jobs.add_to_work_requests"), p_96776_ -> this.send()));
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        this.addButton.f_93624_ = !this.getFirst().m_41619_();
        this.delegate.renderBg(stack, partialTicks, mouseX, mouseY);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        String renderString = "Jobs:";
        ImmutableRect2i textArea = this.getTitleArea();
        Compat.drawLightText(this.f_96547_, stack, renderString, textArea.getX(), textArea.getY());
        Ingredients.render(this.f_96542_, this.requestedItem, textArea.getX() + textArea.getWidth() - 16, textArea.getY() - 6);
        this.delegate.afterRender(stack, this.f_96547_, mouseX, mouseY, partialTicks, this.jobs, false);
        this.renderTooltips(stack, mouseX, mouseY, textArea.expandBy(4));
    }

    public boolean m_6375_(double x, double y, int p_94697_) {
        @NotNull ImmutableRect2i ta = this.getTitleArea();
        Supplier<Boolean> in = () -> UtilClean.isCoordInBox(x, y, ta.getX(), ta.getY(), ta.getWidth(), ta.getHeight());
        if (in.get().booleanValue() && !this.requestedItem.m_43947_()) {
            AddWorkFromUIMessage m = new AddWorkFromUIMessage(this.requestedItem, this.flagPos, AddWorkFromUIMessage.Action.REJECTED);
            QuestownNetwork.CHANNEL.sendToServer((Object)m);
        }
        return super.m_6375_(x, y, p_94697_);
    }

    @NotNull
    private ImmutableRect2i getTitleArea() {
        String sizeString = "Jobs:XXX";
        ImmutableRect2i pageArea = MathUtil.union((ImmutableRect2i)this.delegate.previousPage.getArea(), (ImmutableRect2i)this.delegate.nextPage.getArea());
        pageArea = pageArea.moveUp(16);
        ImmutableRect2i textArea = MathUtil.centerTextArea((ImmutableRect2i)pageArea, (Font)this.f_96547_, (String)sizeString);
        return textArea;
    }

    private void renderTooltips(PoseStack stack, int mouseX, int mouseY, ImmutableRect2i textArea) {
        if (UtilClean.isCoordInBox(mouseX, mouseY, textArea.getX(), textArea.getY(), textArea.getWidth(), textArea.getHeight())) {
            ItemJobsScreen.m_93172_((PoseStack)stack, (int)textArea.getX(), (int)textArea.getY(), (int)(textArea.getX() + textArea.getWidth()), (int)(textArea.getY() + textArea.getHeight()), (int)0x30000000);
            this.m_169388_(stack, (List)ImmutableList.of((Object)Compat.translatable("menu.item_jobs.title_tooltip"), (Object)Ingredients.getName(this.requestedItem)), Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
        return this.delegate.mouseScrolled(p_94686_, p_94687_, p_94688_, (arg_0, arg_1) -> ((ItemJobsScreen)this).m_5953_(arg_0, arg_1), (TriPredicate<Double, Double, Double>)((TriPredicate)this::m_6050_));
    }

    private List<Component> renderCardContent(PoseStack stack, PagedCardScreen.Card<UIJob> card, Coordinate mouse) {
        PagedCardScreen.CardCoordinates c = card.coords();
        UIJob d = card.data();
        int x = c.leftX();
        Function<PagedCardScreen.CardCoordinates, PagedCardScreen.CardCoordinates> scootch = cc -> cc.shiftedDown(12);
        Function<PagedCardScreen.CardCoordinates, PagedCardScreen.CardCoordinates> down = cc -> cc.shiftedDown(16);
        Function<PagedCardScreen.CardCoordinates, PagedCardScreen.CardCoordinates> down2 = cc -> cc.shiftedDown(24);
        Function<PagedCardScreen.CardCoordinates, PagedCardScreen.CardCoordinates> down3 = cc -> cc.shiftedDown(30);
        this.renderJobTitle(stack, d);
        TriFunction renderStrip = (cc, ings, shiftRight) -> RenderUtil.stripOfRequestableItems((ing, coord) -> Ingredients.render(this.f_96542_, ing, coord.x(), coord.y()), ing -> ImmutableList.of((Object)Ingredients.getName(ing)), (BiConsumer<Component, Coordinate>)((BiConsumer)(text, coord) -> Compat.drawDarkText(this.f_96547_, stack, text, (int)coord.x(), (int)coord.y())), (BiConsumer<Coordinate, Coordinate>)((BiConsumer)(topLeft, botRight) -> RenderUtil.highlight(stack, topLeft, botRight)), ings, shiftRight != false ? cc.topLeft().shifted(64, 0) : cc.topLeft(), cc.bottomRight(), mouse);
        Component itemsText = Compat.translatable("menu.item_jobs.items_used");
        int labelOffset = 5;
        c = down2.apply(c);
        Compat.drawDarkText(this.f_96547_, stack, itemsText, x, c.topY() + labelOffset);
        List tt1 = (List)renderStrip.apply((Object)c, d.ingredients(), (Object)true);
        Objects.requireNonNull(this.f_96547_);
        c = c.shiftedDown(9);
        Component toolsText = Compat.translatable("menu.item_jobs.tools_used");
        c = down.apply(c);
        Compat.drawDarkText(this.f_96547_, stack, toolsText, x, c.topY() + labelOffset);
        List tt2 = (List)renderStrip.apply((Object)c, d.tools(), (Object)true);
        Objects.requireNonNull(this.f_96547_);
        c = c.shiftedDown(9);
        Component producesText = Compat.translatable("menu.item_jobs.produces");
        c = down.apply(c);
        Compat.drawDarkText(this.f_96547_, stack, producesText, x, c.topY() + labelOffset);
        List<Ingredient> v = Ingredients.fromItems(d.result());
        List tt3 = (List)renderStrip.apply((Object)c, this.putRequestedItemFirst(v), (Object)true);
        Objects.requireNonNull(this.f_96547_);
        c = c.shiftedDown(9);
        Component roomName = Compat.translatable("room." + d.roomNameTranslationKey().m_135815_());
        MutableComponent translatable = Compat.translatable("menu.item_jobs.room", roomName);
        c = down.apply(c);
        Compat.drawDarkText(this.f_96547_, stack, (Component)translatable, x, c.topY());
        List tt4 = (List)renderStrip.apply((Object)scootch.apply(c), d.roomRecipe(), (Object)false);
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - this.delegate.backgroundHeight) / 2;
        int stripHeight = 24;
        int stripY = bgY + this.delegate.backgroundHeight - stripHeight - 13 - 4 - 20;
        ItemJobsScreen.m_93172_((PoseStack)stack, (int)bgX, (int)stripY, (int)(bgX + 176), (int)(stripY + stripHeight - 2), (int)0x30000000);
        int i = 0;
        for (UUID uuid : d.villagersWhoCanDoJob()) {
            int stripOffset = (stripHeight - 16) / 2;
            ItemJobsScreen.blitFace(stack, bgX + 8 - 3, stripY + --stripOffset, uuid, i++);
        }
        return UtilClean.lastNonNull(tt1, tt2, tt3, tt4);
    }

    private List<Ingredient> putRequestedItemFirst(List<Ingredient> v) {
        if (Ingredients.isTag(this.requestedItem)) {
            return v;
        }
        if (this.requestedItem.m_43947_()) {
            return v;
        }
        ImmutableList.Builder b = ImmutableList.builder();
        b.add((Object)this.requestedItem);
        v.stream().filter(z -> !Ingredients.equal(z, this.requestedItem)).forEach(arg_0 -> ((ImmutableList.Builder)b).add(arg_0));
        return b.build();
    }

    private void renderJobTitle(PoseStack stack, UIJob d) {
        ImmutableRect2i pageArea = MathUtil.union((ImmutableRect2i)this.delegate.previousPage.getArea(), (ImmutableRect2i)this.delegate.nextPage.getArea());
        pageArea = pageArea.moveDown(20);
        MutableComponent jobName = Compat.translatable("menu.common.job_name", Jobs.getRootNameComponent(d.jobId()), Compat.literal(d.jobId().jobId()));
        ImmutableRect2i textArea = MathUtil.centerTextArea((ImmutableRect2i)pageArea, (Font)this.f_96547_, (FormattedText)jobName);
        Compat.drawDarkText(this.f_96547_, stack, (Component)jobName, textArea.getX(), textArea.getY());
    }

    private static void blitFace(PoseStack stack, int x, int y, UUID uuid, int i) {
        Util.blitFace(stack, uuid, x + 32 * i, y, 2);
    }

    public boolean m_7043_() {
        return false;
    }

    public List<Rect2i> getExtraAreas() {
        return this.delegate.getExtraAreas();
    }
}

