/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.Coordinate;
import ca.bradj.questown.core.Pair;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.JEI;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.TriPredicate;

public final class PagedCardScreen<D> {
    public static final int backgroundWidth = 176;
    public final int backgroundHeight;
    public static final int borderPadding = 6;
    public static final int buttonWidth = 13;
    public static final int SMALL_PADDING = 1;
    public static final int MED_PADDING = 5;
    public static final int BIG_PADDING = 10;
    public static final int UNSCALED_CARD_HEIGHT = 42;
    public static final int CARD_WIDTH = 156;
    public static final int buttonHeight = 13;
    private final Supplier<Integer> height;
    private final Supplier<Integer> width;
    private final JEI.NineNine background;
    final GuiIconButtonSmall nextPage;
    final GuiIconButtonSmall previousPage;
    private final JEI.NineNine cardBackground;
    private final Consumer<D> setRenderColorForCard;
    private final CardRenderer<D> renderCardContent;
    private final Supplier<List<D>> cardsData;
    public final int MAX_CARDS_PER_PAGE;
    public final int cardHeight;
    private final int buttonY;
    private int currentPage = 0;

    public int backgroundWidth() {
        return 176;
    }

    public int getCurrentPageIndex() {
        return this.currentPage;
    }

    public PagedCardScreen(Supplier<Integer> height, Supplier<Integer> width, Supplier<List<D>> cardsData, Consumer<D> setRenderColorForCard, CardRenderer<D> renderCardContent, int heightScale, int buttonY, int extraHeight) {
        this.height = height;
        this.width = width;
        this.backgroundHeight = 166 + extraHeight;
        this.background = JEI.getRecipeBackground();
        IDrawableStatic arrowNext = JEI.getArrowNext();
        IDrawableStatic arrowPrevious = JEI.getArrowPrevious();
        this.nextPage = JEI.guiIconButtonSmall(0, 0, 13, 13, (IDrawable)arrowNext, b -> this.nextPage());
        this.previousPage = JEI.guiIconButtonSmall(0, 0, 13, 13, (IDrawable)arrowPrevious, b -> this.previousPage());
        this.cardBackground = JEI.getRecipeBackground();
        this.cardsData = cardsData;
        this.setRenderColorForCard = setRenderColorForCard;
        this.renderCardContent = renderCardContent;
        this.cardHeight = 42 * heightScale;
        this.MAX_CARDS_PER_PAGE = PagedCardScreen.getCardsPerPage(this.backgroundHeight, this.cardHeight);
        this.buttonY = buttonY;
    }

    @NotNull
    public <D> ImmutableList<Card<D>> getCardLayout(int screenWidth, int screenHeight, int bgWidth, int bgHeight, int currentPage, List<D> cardsData) {
        int bgX = (screenWidth - bgWidth) / 2;
        int bgY = (screenHeight - bgHeight) / 2;
        int x = bgX;
        int y = bgY;
        int pageStringY = y + 10;
        y = pageStringY + 10;
        int MAX_CARDS_PER_PAGE = PagedCardScreen.getCardsPerPage(bgHeight, this.cardHeight);
        int startIndex = currentPage * MAX_CARDS_PER_PAGE;
        int endIndex = Math.min(startIndex + MAX_CARDS_PER_PAGE, cardsData.size());
        x += 10;
        y += 10;
        ImmutableList.Builder b = ImmutableList.builder();
        for (int i = startIndex; i < endIndex; ++i) {
            int row = i - startIndex;
            int cardY = this.getCardY(y, row);
            D data = cardsData.get(i);
            CardCoordinates coords = new CardCoordinates(x, cardY, x + 156, cardY + this.cardHeight, 10);
            b.add(new Card<D>(i, coords, data));
        }
        return b.build();
    }

    public static int getCardsPerPage(int bgHeight, int cardHeight) {
        return (bgHeight - 10) / (cardHeight + 1);
    }

    private int getCardY(int y, int row) {
        return y + row * (this.cardHeight + 1);
    }

    protected void afterInit(Consumer<GuiIconButtonSmall> addRenderableWidget) {
        int y = (this.height.get() - this.backgroundHeight) / 2;
        int pageStringY = y + 6;
        int x = (this.width.get() - 176) / 2;
        this.previousPage.f_93620_ = x + 6;
        this.previousPage.f_93621_ = pageStringY + this.buttonY;
        this.nextPage.f_93620_ = x + 176 - 13 - 6;
        this.nextPage.f_93621_ = pageStringY + this.buttonY;
        addRenderableWidget.accept(this.previousPage);
        addRenderableWidget.accept(this.nextPage);
    }

    protected void renderBg(PoseStack stack, float v, int i, int i1) {
        int bgX = (this.width.get() - 176) / 2;
        int bgY = (this.height.get() - this.backgroundHeight) / 2;
        this.background.draw(stack, bgX, bgY, 176, this.backgroundHeight);
    }

    @Nullable
    public List<Component> afterRender(PoseStack poseStack, Font font, int mouseX, int mouseY, float partialTicks, List<D> cardsData, boolean drawCardBg) {
        this.renderButtons(poseStack, font, mouseX, mouseY, partialTicks, cardsData);
        return this.renderCards(poseStack, mouseX, mouseY, drawCardBg);
    }

    public void renderButtons(PoseStack poseStack, Font font, int mouseX, int mouseY, float partialTicks, List<D> cardsData) {
        int bgX = (this.width.get() - 176) / 2;
        this.renderPageNum(poseStack, font, bgX, cardsData, (TriConsumer<PoseStack, Pair<Integer, Integer>, Pair<Integer, Integer>>)((TriConsumer)(s, pos, size) -> GuiComponent.m_93172_((PoseStack)poseStack, (int)((Integer)pos.a()), (int)((Integer)pos.b()), (int)((Integer)size.a()), (int)((Integer)size.b()), (int)0x30000000)));
        this.previousPage.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.nextPage.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    @Nullable
    private List<Component> renderCards(PoseStack poseStack, int mouseX, int mouseY, boolean drawCardBg) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Coordinate mousePosition = new Coordinate(mouseX, mouseY);
        List<Component> tooltip = null;
        for (Card<D> card : this.cards()) {
            List<Component> tt;
            if (drawCardBg) {
                this.setRenderColorForCard.accept(card.data());
                int x2 = card.coords().leftX();
                int y2 = card.coords.topY();
                this.cardBackground.draw(poseStack, x2, y2, 156, this.cardHeight);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if ((tt = this.renderCardContent.renderAndReturnTooltip(poseStack, card, mousePosition)) == null) continue;
            if (tooltip != null) {
                QT.GUI_LOGGER.warn("Multiple tooltips returned for card. Newest will be used.", new Object[0]);
                continue;
            }
            tooltip = tt;
        }
        return tooltip;
    }

    public Collection<Card<D>> cards() {
        return this.getCardLayout(this.width.get(), this.height.get(), 176, this.backgroundHeight, this.currentPage, this.cardsData.get());
    }

    private void renderPageNum(PoseStack poseStack, Font font, int x, List<D> cardsData, TriConsumer<PoseStack, Pair<Integer, Integer>, Pair<Integer, Integer>> fill) {
        int xx = x + 6 + 13;
        int y = this.nextPage.f_93621_;
        int width = xx + 176 - 6 - 13;
        int height = this.nextPage.f_93621_ + 13;
        fill.accept((Object)poseStack, new Pair<Integer, Integer>(xx, y), new Pair<Integer, Integer>(width, height));
        int totalPages = (int)Math.ceil((double)cardsData.size() / (double)this.MAX_CARDS_PER_PAGE);
        String pageString = "Page " + (this.currentPage + 1) + " / " + totalPages;
        ImmutableRect2i pageArea = MathUtil.union((ImmutableRect2i)this.previousPage.getArea(), (ImmutableRect2i)this.nextPage.getArea());
        ImmutableRect2i textArea = MathUtil.centerTextArea((ImmutableRect2i)pageArea, (Font)font, (String)pageString);
        Compat.drawLightText(font, poseStack, pageString, textArea.getX(), textArea.getY());
    }

    private void nextPage() {
        int totalPages = (int)Math.ceil((double)this.cardsData.get().size() / (double)this.MAX_CARDS_PER_PAGE);
        if (this.currentPage < totalPages - 1) {
            ++this.currentPage;
        }
    }

    private void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
    }

    public boolean mouseScrolled(double scrollX, double scrollY, double scrollDelta, BiPredicate<Double, Double> isMouseOver, TriPredicate<Double, Double, Double> mouseScrolled) {
        double x = JEI.getX();
        double y = JEI.getY();
        if (isMouseOver.test(x, y)) {
            if (scrollDelta < 0.0) {
                this.nextPage();
                return true;
            }
            if (scrollDelta > 0.0) {
                this.previousPage();
                return true;
            }
        }
        return mouseScrolled.test((Object)scrollX, (Object)scrollY, (Object)scrollDelta);
    }

    public List<Rect2i> getExtraAreas() {
        int x = (this.width.get() - 176) / 2;
        int y = (this.height.get() - this.backgroundHeight) / 2;
        return ImmutableList.of((Object)new Rect2i(x, y, 176, this.backgroundHeight));
    }

    public static interface CardRenderer<D> {
        public List<Component> renderAndReturnTooltip(PoseStack var1, Card<D> var2, Coordinate var3);
    }

    public record CardCoordinates(int leftX, int topY, int rightX, int bottomY, int padding) {
        public CardCoordinates shiftedUp(int i) {
            return new CardCoordinates(this.leftX, this.topY - i, this.rightX, this.bottomY, this.padding);
        }

        public CardCoordinates shiftedDown(int i) {
            return new CardCoordinates(this.leftX, this.topY + i, this.rightX, this.bottomY, this.padding);
        }

        public Coordinate topLeft() {
            return new Coordinate(this.leftX, this.topY);
        }

        public Coordinate bottomRight() {
            return new Coordinate(this.rightX, this.bottomY);
        }

        public CardCoordinates padded() {
            return new CardCoordinates(this.leftXPadded(), this.topYPadded(), this.rightXPadded(), this.bottomYPadded(), this.padding);
        }

        public int bottomYPadded() {
            return this.bottomY - this.padding;
        }

        public int rightXPadded() {
            return this.rightX - this.padding;
        }

        public int topYPadded() {
            return this.topY + this.padding;
        }

        public int leftXPadded() {
            return this.leftX + this.padding;
        }
    }

    public record Card<D>(int index, CardCoordinates coords, D data) {
    }
}

