/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.gui.TownRemoveQuestsContainer;
import ca.bradj.questown.gui.UIQuest;
import ca.bradj.questown.logic.RoomRecipes;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.JEI;
import ca.bradj.questown.town.quests.Quest;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class QuestRemoveConfirmScreen
extends AbstractContainerScreen<TownRemoveQuestsContainer> {
    private static final int backgroundWidth = 176;
    private static final int backgroundHeight = 166;
    private static final int borderPadding = 6;
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 13;
    private static final int TEXT_COLOR = 0x404040;
    private static final int CARD_PADDING = 1;
    private static final int PAGE_PADDING = 10;
    private static final int CARD_WIDTH = 156;
    private static final int CARD_HEIGHT = 42;
    private int MAX_CARDS_PER_PAGE;
    private final List<UIQuest> quests;
    private final JEI.NineNine background;
    private final JEI.NineNine cardBackground;
    private final GuiIconButtonSmall nextPage;
    private final GuiIconButtonSmall previousPage;
    private final List<ItemStack> heads;
    private int currentPage = 0;
    private final List<Slot> slots = new ArrayList<Slot>();

    public QuestRemoveConfirmScreen(TownRemoveQuestsContainer container, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)container, playerInv, title);
        this.f_97726_ = 256;
        this.f_97727_ = 220;
        this.quests = ImmutableList.copyOf(container.GetQuests());
        this.background = JEI.getRecipeGuiBackground();
        this.cardBackground = JEI.getRecipeBackground();
        IDrawableStatic arrowNext = JEI.getArrowNext();
        IDrawableStatic arrowPrevious = JEI.getArrowPrevious();
        this.nextPage = JEI.guiIconButtonSmall(0, 0, 13, 13, (IDrawable)arrowNext, b -> this.nextPage());
        this.previousPage = JEI.guiIconButtonSmall(0, 0, 13, 13, (IDrawable)arrowPrevious, b -> this.previousPage());
        this.heads = this.quests.stream().map(v -> {
            if (v.villagerUUID() == null) {
                return null;
            }
            ItemStack head = new ItemStack((ItemLike)Items.f_42680_);
            head.m_41784_().m_128359_("SkullOwner", v.villagerUUID());
            return head;
        }).toList();
    }

    protected void m_7856_() {
        int buttonHeight = 20;
        Objects.requireNonNull(this.f_96547_);
        int addedText = (9 + 1) * 2;
        int cardSpaceHeight = 156 - addedText - buttonHeight;
        this.MAX_CARDS_PER_PAGE = cardSpaceHeight / 43;
        int y = (this.f_96544_ - 166) / 2;
        int pageStringY = y + 6;
        int x = (this.f_96543_ - 176) / 2;
        this.previousPage.f_93620_ = x + 6;
        this.previousPage.f_93621_ = pageStringY;
        this.nextPage.f_93620_ = x + 176 - 13 - 6;
        this.nextPage.f_93621_ = pageStringY;
        this.m_142416_((GuiEventListener)this.previousPage);
        this.m_142416_((GuiEventListener)this.nextPage);
        int maybeX = this.f_96543_ / 2 + 32;
        int cardsHeight = this.MAX_CARDS_PER_PAGE * 43;
        int n = pageStringY + this.previousPage.m_93694_() + 10 + cardsHeight;
        Objects.requireNonNull(this.f_96547_);
        int maybeY = n + 2 * 9 + 6;
        this.m_142416_((GuiEventListener)new Button(x + 6, maybeY, 48, buttonHeight, Compat.translatable("menu.back"), p_96776_ -> ((TownRemoveQuestsContainer)this.f_97732_).sendOpenQuestsMenuRequest()));
        this.m_142416_((GuiEventListener)new Button(maybeX, maybeY, 48, buttonHeight, Compat.translatable("menu.decline"), p_96776_ -> ((TownRemoveQuestsContainer)this.f_97732_).sendConfirmRemoveRequest()));
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 81) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        int pageStringY = y + 10;
        this.renderPageNum(poseStack, x);
        y = pageStringY + 10;
        int startIndex = this.currentPage * this.MAX_CARDS_PER_PAGE;
        int endIndex = Math.min(startIndex + this.MAX_CARDS_PER_PAGE, this.quests.size());
        this.f_96547_.m_92889_(poseStack, (Component)Compat.translatable("menu.quests.confirm_remove_top", this.quests.size()), (float)(x += 10), (float)(y += 10), 0x404040);
        Objects.requireNonNull(this.f_96547_);
        y = y + 9 + 1;
        ImmutableList.Builder b = ImmutableList.builder();
        for (int i = startIndex; i < endIndex; ++i) {
            boolean showHead;
            int index = i;
            int row = i - startIndex;
            int cardY = y + row * 43;
            UIQuest recipe = this.quests.get(i);
            if (recipe == null) continue;
            Component recipeName = recipe.getName();
            if (recipe.fromRecipe != null) {
                Component fromName = RoomRecipes.getName(recipe.fromRecipe);
                recipeName = Compat.translatable("quests.upgrade", fromName, recipeName);
            }
            if (Quest.QuestStatus.COMPLETED.equals((Object)recipe.status)) {
                RenderSystem.m_157429_((float)0.8f, (float)1.0f, (float)0.8f, (float)1.0f);
                recipeName = Compat.translatable("quests.completed_suffix", recipeName);
            }
            if (recipe.isBroken) {
                RenderSystem.m_157429_((float)0.85f, (float)0.75f, (float)1.0f, (float)1.0f);
            }
            this.cardBackground.draw(poseStack, x, cardY, 156, 42);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int iconY = cardY + 42 - 24;
            ImmutableList<Slot> slotz = this.renderRecipeCardIcons(poseStack, recipe, x, iconY, mouseX, mouseY);
            b.addAll(slotz);
            int idX = x + 10;
            int idY = iconY - 10;
            this.f_96547_.m_92883_(poseStack, recipeName.getString(), (float)idX, (float)idY, 0x404040);
            String vID = recipe.villagerUUID();
            String jobName = recipe.jobName();
            MutableComponent tooltip = Compat.translatable("quests.job_owner", vID);
            if (vID.isEmpty()) continue;
            boolean hasJob = jobName.isEmpty();
            if (!hasJob) {
                tooltip = Compat.translatable("quests.job_change", vID, jobName);
            }
            boolean bl = showHead = !hasJob;
            if (mouseX >= x && mouseY >= cardY && mouseX < x + 156 && mouseY < cardY + 42) {
                showHead = true;
            }
            if (!showHead) continue;
            int headX = x + 156 - 19 - 19;
            int headY = idY - 6;
            this.f_96542_.m_115203_(this.heads.get(i), headX, headY);
            if (mouseX < headX || mouseY < headY || mouseX >= headX + 16 || mouseY >= headY + 17) continue;
            this.highlightAndTooltip(poseStack, headX, headY, (Component)tooltip, mouseX, mouseY);
        }
        this.slots.clear();
        this.slots.addAll((Collection<Slot>)b.build());
        int botY = y + (endIndex - startIndex) * 43 + 2;
        this.f_96547_.m_92889_(poseStack, Compat.translatable("menu.quests.confirm_remove_bottom"), (float)x, (float)botY, 0x404040);
        this.previousPage.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.nextPage.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    private ImmutableList<Slot> renderRecipeCardIcons(PoseStack poseStack, UIQuest recipe, int x, int y, int mouseX, int mouseY) {
        Inventory dummyInv = new Inventory(null);
        Collection<Ingredient> ingredients = recipe.getIngredients();
        ingredients = RoomRecipes.filterSpecialBlocks(ingredients);
        int j = 0;
        ImmutableList.Builder b = ImmutableList.builder();
        for (Ingredient ing : ingredients) {
            int iconX;
            ItemStack itemStack = Ingredients.render(this.f_96542_, ing, iconX = x + 8 + j * 18, y + 1);
            if (itemStack != null) {
                if (mouseX >= iconX && mouseY >= y && mouseX < iconX + 16 && mouseY < y + 17) {
                    this.highlightAndTooltip(poseStack, iconX, y, itemStack.m_41720_().m_7626_(itemStack), mouseX, mouseY);
                }
                Slot element = new Slot((Container)dummyInv, j, iconX, y + 1);
                element.m_5852_(itemStack);
                b.add((Object)element);
            }
            ++j;
        }
        return b.build();
    }

    private void highlightAndTooltip(PoseStack poseStack, int iconX, int y, Component itemStack, int mouseX, int mouseY) {
        QuestRemoveConfirmScreen.m_93172_((PoseStack)poseStack, (int)iconX, (int)(y + 1), (int)(iconX + 16), (int)(y + 17), (int)-2130706433);
        this.m_96602_(poseStack, itemStack, mouseX, mouseY);
    }

    private void renderPageNum(PoseStack poseStack, int x) {
        QuestRemoveConfirmScreen.m_93172_((PoseStack)poseStack, (int)(x + 6 + 13), (int)this.nextPage.f_93621_, (int)(x + 176 - 6 - 13), (int)(this.nextPage.f_93621_ + 13), (int)0x30000000);
        int totalPages = (int)Math.ceil((double)this.quests.size() / (double)this.MAX_CARDS_PER_PAGE);
        String pageString = "Page " + (this.currentPage + 1) + " / " + totalPages;
        ImmutableRect2i pageArea = MathUtil.union((ImmutableRect2i)this.previousPage.getArea(), (ImmutableRect2i)this.nextPage.getArea());
        ImmutableRect2i textArea = MathUtil.centerTextArea((ImmutableRect2i)pageArea, (Font)this.f_96547_, (String)pageString);
        Compat.drawLightText(this.f_96547_, poseStack, pageString, textArea.getX(), textArea.getY());
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        this.background.draw(poseStack, x, y, 176, 166);
    }

    private void renderSlot(PoseStack poseStack, Slot slot, int mouseX, int mouseY, float partialTicks) {
        ItemStack stack = slot.m_7993_();
        if (!stack.m_41619_()) {
            this.f_96541_.m_91291_().m_115123_(stack, slot.f_40220_, slot.f_40221_);
            this.f_96541_.m_91291_().m_115174_(this.f_96547_, stack, slot.f_40220_, slot.f_40221_, "");
        }
    }

    private void nextPage() {
        int totalPages = (int)Math.ceil((double)this.quests.size() / (double)this.MAX_CARDS_PER_PAGE);
        if (this.currentPage < totalPages - 1) {
            ++this.currentPage;
        }
    }

    private void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public List<Rect2i> getExtraAreas() {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        return ImmutableList.of((Object)new Rect2i(x, y, 176, 166));
    }

    public ItemStack getHoveredIngredient(int mouseX, int mouseY) {
        Predicate<Slot> slotPredicate = s -> mouseX >= s.f_40220_ && mouseX <= s.f_40220_ + 16 && mouseY >= s.f_40221_ + 1 && mouseY <= s.f_40221_ + 17;
        Stream<Slot> matches = this.slots.stream().filter(slotPredicate);
        Optional<Slot> found = matches.findAny();
        return found.map(Slot::m_7993_).orElse(ItemStack.f_41583_);
    }

    public boolean m_6050_(double scrollX, double scrollY, double scrollDelta) {
        double y;
        double x = JEI.getX();
        if (this.m_5953_(x, y = JEI.getY())) {
            if (scrollDelta < 0.0) {
                this.nextPage();
                return true;
            }
            if (scrollDelta > 0.0) {
                this.previousPage();
                return true;
            }
        }
        return super.m_6050_(scrollX, scrollY, scrollDelta);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return true;
    }
}

