/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.Coordinate;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.gui.AbstractPagedCardScreen;
import ca.bradj.questown.gui.AbstractQuestsContainer;
import ca.bradj.questown.gui.FlagTabs;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.gui.PagedCardScreen;
import ca.bradj.questown.gui.RenderContext;
import ca.bradj.questown.gui.RenderUtil;
import ca.bradj.questown.gui.SubUI;
import ca.bradj.questown.gui.TownQuestsContainer;
import ca.bradj.questown.gui.UIQuest;
import ca.bradj.questown.gui.VillagerQuestsContainer;
import ca.bradj.questown.gui.VillagerTabs;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.logic.RoomRecipes;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.JEI;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.town.quests.Quest;
import ca.bradj.roomrecipes.core.space.Position;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.util.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestsScreen<C extends AbstractQuestsContainer>
extends AbstractPagedCardScreen<C, UIQuest> {
    private static final int backgroundWidth = 176;
    private static final int backgroundHeight = 166;
    private static final int TEXT_COLOR = 0x404040;
    private final List<UIQuest> quests;
    private final JEI.NineNine background;
    private final Map<Position, Runnable> removes = new HashMap<Position, Runnable>();
    private final SubUI tabs;

    public QuestsScreen(C container, Inventory playerInv, Component title, SubUI tabs) {
        super(container, playerInv, title);
        this.f_97726_ = 256;
        this.f_97727_ = 220;
        this.quests = ImmutableList.copyOf(((AbstractQuestsContainer)((Object)container)).GetQuests());
        this.background = JEI.getRecipeGuiBackground();
        this.tabs = tabs;
    }

    @Override
    protected ImmutableList<UIQuest> cardsData() {
        return ImmutableList.copyOf(this.quests);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 81) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_7027_(PoseStack p_97808_, int p_97809_, int p_97810_) {
    }

    protected void m_7025_(PoseStack stack, int mouseX, int mouseY) {
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - 166) / 2;
        if (this.tabs.renderTooltip(bgX, bgY, mouseX, mouseY, key -> super.m_96602_(stack, Compat.translatable(key), mouseX, mouseY))) {
            return;
        }
        super.m_7025_(stack, mouseX, mouseY);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - 166) / 2;
        this.tabs.draw(new RenderContext(this.f_96542_, poseStack), bgX, bgY);
    }

    @Override
    protected List<Component> renderCardContent(PoseStack poseStack, PagedCardScreen.Card<UIQuest> card, int mouseX, int mouseY) {
        UIQuest recipe = this.quests.get(card.index());
        if (recipe == null) {
            return null;
        }
        Component recipeName = recipe.getName();
        if (recipe.fromRecipe != null) {
            Component fromName = RoomRecipes.getName(recipe.fromRecipe);
            recipeName = Compat.translatable("quests.upgrade", fromName, recipeName);
        }
        if (Quest.QuestStatus.COMPLETED.equals((Object)recipe.status)) {
            recipeName = Compat.translatable("quests.completed_suffix", recipeName);
        }
        int iconY = card.coords().bottomYPadded() - 10;
        int idX = card.coords().leftXPadded();
        int idY = card.coords().topYPadded();
        this.f_96547_.m_92883_(poseStack, recipeName.getString(), (float)idX, (float)card.coords().topYPadded(), 0x404040);
        String vID = recipe.villagerUUID();
        String jobName = recipe.jobName();
        MutableComponent tooltip = Compat.translatable("quests.job_owner", QuestsScreen.getVillagerName(vID));
        PagedCardScreen.CardCoordinates shiftedUp = card.coords().shiftedUp(5);
        Component removalTooltip = null;
        if (recipe.getBatchUUID() != null) {
            removalTooltip = this.renderRemovalButton(poseStack, mouseX, mouseY, shiftedUp, recipe.getBatchUUID());
        }
        Coordinate mouse = new Coordinate(mouseX, mouseY);
        Component renderedHeadTooltip = null;
        if (!vID.isEmpty()) {
            renderedHeadTooltip = this.renderHead(poseStack, card, mouse, jobName, (Component)tooltip, vID, shiftedUp);
        }
        @Nullable List<Component> renderedItemTooltip = this.renderRecipeCardIcons(poseStack, recipe, new Coordinate(card.coords().leftXPadded(), iconY), card.coords().padded().bottomRight(), mouse);
        return QuestsScreen.renderCardTooltip(card, removalTooltip, renderedHeadTooltip, renderedItemTooltip, mouse, recipe);
    }

    @Nullable
    private static List<Component> renderCardTooltip(PagedCardScreen.Card<UIQuest> card, @Nullable Component removalTooltip, @Nullable Component renderedHeadTooltip, @Nullable List<Component> renderedItemTooltip, Coordinate mouse, UIQuest recipe) {
        if (removalTooltip != null) {
            return ImmutableList.of((Object)removalTooltip);
        }
        if (renderedHeadTooltip != null) {
            return ImmutableList.of((Object)renderedHeadTooltip);
        }
        if (renderedItemTooltip != null) {
            return renderedItemTooltip;
        }
        if (!UtilClean.isCoordInBox(mouse, card.coords().topLeft(), card.coords().bottomRight())) {
            return null;
        }
        return switch (recipe.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case Quest.QuestType.ITEM -> QuestsScreen.renderItemQuestTooltip(recipe);
            case Quest.QuestType.ROOM -> ImmutableList.of((Object)Compat.translatable("menu.quests.room_quest"));
            case Quest.QuestType.JOB_CHANGE -> QuestsScreen.renderJobQuestTooltip(recipe);
            case Quest.QuestType.UNKNOWN -> null;
        };
    }

    private static ImmutableList<Component> renderItemQuestTooltip(UIQuest recipe) {
        int size = recipe.getIngredients().size();
        Component name = Compat.getItemName(recipe.getWantedId());
        return ImmutableList.of((Object)Compat.translatable("menu.quests.item_quest", size, name));
    }

    private static ImmutableList<Component> renderJobQuestTooltip(UIQuest recipe) {
        JobID job = JobID.fromRL(recipe.getWantedId());
        return ImmutableList.of((Object)Compat.translatable("menu.questown.quests.job_quest_1", job.jobId()), (Object)Compat.translatable("menu.questown.quests.job_quest_2", job.rootId()));
    }

    @Nullable
    private Component renderHead(PoseStack poseStack, PagedCardScreen.Card<UIQuest> card, Coordinate mouse, String jobName, Component tooltip, String vID, PagedCardScreen.CardCoordinates shiftedUp) {
        boolean showHead;
        boolean hasJob = jobName.isEmpty();
        if (!hasJob) {
            tooltip = Compat.translatable("quests.job_change", vID, jobName);
        }
        boolean bl = showHead = !hasJob;
        if (UtilClean.isCoordInBox(mouse, card.coords().topLeft(), card.coords().bottomRight())) {
            showHead = true;
        }
        if (showHead) {
            int headX = card.coords().rightX() - 19 - 20;
            int headY = shiftedUp.topYPadded() - 1;
            Util.blitFace(poseStack, UUID.fromString(vID), headX, headY + 1, 2);
            if (UtilClean.isCoordInBox(mouse, new Coordinate(headX, headY + 1), new Coordinate(headX + 16, headY + 17))) {
                QuestsScreen.m_93172_((PoseStack)poseStack, (int)headX, (int)(headY + 1), (int)(headX + 16), (int)(headY + 17), (int)-2130706433);
                return tooltip;
            }
        }
        return null;
    }

    @NotNull
    private static String getVillagerName(String vID) {
        return UtilClean.truncateMiddle(vID);
    }

    @Nullable
    private Component renderRemovalButton(PoseStack poseStack, int mouseX, int mouseY, PagedCardScreen.CardCoordinates coords, UUID index) {
        int removeButtonX = coords.rightXPadded() - 13;
        int removeButtonY = coords.topYPadded();
        this.f_96547_.m_92763_(poseStack, Compat.literal("x"), (float)removeButtonX + 6.5f - 1.0f, (float)removeButtonY + 6.5f - 3.0f, 0xFFFFFF);
        this.removes.put(new Position(removeButtonX, removeButtonY), () -> ((AbstractQuestsContainer)this.f_97732_).sendRemoveRequest(index));
        return this.highlightAndTooltip(poseStack, mouseX, mouseY, removeButtonX, removeButtonY, Compat.translatable("job_board.remove_work"));
    }

    @Nullable
    private Component highlightAndTooltip(PoseStack poseStack, int mouseX, int mouseY, int iconX, int iconY, Component tooltipText) {
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - 166) / 2;
        if (this.tabs.renderTooltip(bgX, bgY, mouseX, mouseY, key -> super.m_96602_(poseStack, Compat.translatable(key), mouseX, mouseY))) {
            return null;
        }
        if (mouseX >= iconX && mouseY >= iconY && mouseX < iconX + 16 && mouseY < iconY + 16) {
            QuestsScreen.m_93172_((PoseStack)poseStack, (int)iconX, (int)iconY, (int)(iconX + 16), (int)(iconY + 16), (int)-2130706433);
            return tooltipText;
        }
        return null;
    }

    public boolean m_6375_(double x, double y, int p_97750_) {
        for (Map.Entry<Position, Runnable> p : this.removes.entrySet()) {
            int buttonX = p.getKey().x;
            int buttonY = p.getKey().z;
            if (!(x >= (double)buttonX) || !(y >= (double)buttonY) || !(x < (double)(buttonX + 16)) || !(y < (double)(buttonY + 17))) continue;
            p.getValue().run();
            return true;
        }
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - 166) / 2;
        this.tabs.mouseClicked(bgX, bgY, x, y);
        return super.m_6375_(x, y, p_97750_);
    }

    @Nullable
    private List<Component> renderRecipeCardIcons(PoseStack poseStack, UIQuest recipe, Coordinate stripTopLeft, Coordinate cardBottomRight, Coordinate mouse) {
        Collection<Ingredient> ingredients = recipe.getIngredients();
        ingredients = RoomRecipes.filterSpecialBlocks(ingredients);
        return RenderUtil.stripOfRequestableItems((ing, coord) -> Ingredients.render(this.f_96542_, ing, coord.x(), coord.y()), ing -> ImmutableList.of((Object)Ingredients.getName(ing)), (BiConsumer<Component, Coordinate>)((BiConsumer)(text, coord) -> Compat.drawDarkText(this.f_96547_, poseStack, text, (int)coord.x(), (int)coord.y())), (BiConsumer<Coordinate, Coordinate>)((BiConsumer)(topLeft, botRight) -> RenderUtil.highlight(poseStack, topLeft, botRight)), ImmutableList.copyOf(ingredients), stripTopLeft, cardBottomRight, mouse);
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        this.background.draw(poseStack, x, y, 176, 166);
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        return ImmutableList.of((Object)new Rect2i(x, y, 176, 166));
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return true;
    }

    public static QuestsScreen<TownQuestsContainer> forTown(TownQuestsContainer container, Inventory playerInv, Component title) {
        return new QuestsScreen<TownQuestsContainer>(container, playerInv, title, FlagTabs.forMenu(container));
    }

    public static QuestsScreen<VillagerQuestsContainer> forVillager(VillagerQuestsContainer menu, Inventory inventory, Component component) {
        return new QuestsScreen<VillagerQuestsContainer>(menu, inventory, component, VillagerTabs.forMenu(menu));
    }

    @Override
    protected void setRenderColorForCard(UIQuest data) {
        if (Quest.QuestStatus.COMPLETED.equals((Object)data.status)) {
            RenderSystem.m_157429_((float)0.8f, (float)1.0f, (float)0.8f, (float)1.0f);
        }
        if (data.isBroken) {
            RenderSystem.m_157429_((float)0.85f, (float)0.75f, (float)1.0f, (float)1.0f);
        }
    }
}

