/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.Questown;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.declarative.nomc.WorkSeekerJob;
import ca.bradj.questown.jobs.production.ProductionStatus;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class StatusArt {
    private static final Map<ProductionStatus, String> pArt;
    public static final ResourceLocation ERROR_TEX;

    public static ResourceLocation getTexture(JobID jobId, IStatus<?> status) {
        if (status instanceof ProductionStatus) {
            ProductionStatus ps = (ProductionStatus)status;
            String art = pArt.get(ps);
            if (WorkSeekerJob.isSeekingWork(jobId) && ps.isExtractingProduct()) {
                art = "menu/work_seeker.png";
            }
            if (art != null) {
                return Questown.ResourceLocation("textures/" + art);
            }
        }
        return ERROR_TEX;
    }

    static {
        ERROR_TEX = new ResourceLocation("questown", "textures/error.png");
        ImmutableMap.Builder b = ImmutableMap.builder();
        b.put((Object)ProductionStatus.IDLE, (Object)"menu/gatherer/idle.png");
        b.put((Object)ProductionStatus.NO_SPACE, (Object)"menu/gatherer/no_space.png");
        b.put((Object)ProductionStatus.RELAXING, (Object)"menu/gatherer/relaxing.png");
        b.put((Object)ProductionStatus.NO_JOBSITE, (Object)"menu/gatherer/no_jobsite.png");
        b.put((Object)ProductionStatus.GOING_TO_JOB, (Object)"menu/gatherer/leaving.png");
        b.put((Object)ProductionStatus.NO_SUPPLIES, (Object)"menu/gatherer/no_supplies.png");
        b.put((Object)ProductionStatus.COLLECTING_SUPPLIES, (Object)"menu/gatherer/get_supplies.png");
        b.put((Object)ProductionStatus.NO_WORK_POSSIBLE, (Object)"menu/gatherer/no_work_possible.png");
        b.put((Object)ProductionStatus.DROPPING_LOOT, (Object)"menu/gatherer/dropping_loot.png");
        pArt = b.build();
    }
}

