/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.Coordinate;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.gui.ClientAccess;
import ca.bradj.questown.gui.JobTooltips;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.mc.Util;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class StatusGraphic {
    private final EvictingQueue<IStatus<?>> statusSmoothingQueue = EvictingQueue.create((int)20);
    private final Supplier<Coordinate> topLeft;
    private final JobID jobId;
    private final Supplier<IStatus<?>> status;

    public StatusGraphic(JobID jobId, Supplier<Coordinate> topLeft, Supplier<IStatus<?>> status) {
        this.topLeft = topLeft;
        this.jobId = jobId;
        this.status = status;
    }

    @NotNull
    private IStatus<?> getSmoothedStatus() {
        this.statusSmoothingQueue.add(this.status.get());
        HashMap<IStatus, Integer> counter = new HashMap<IStatus, Integer>();
        for (IStatus iStatus : this.statusSmoothingQueue) {
            counter.compute(iStatus, (ignored, oldCt) -> oldCt == null ? 1 : oldCt + 1);
        }
        return counter.entrySet().stream().max(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).orElseThrow();
    }

    public void render(PoseStack stack) {
        IStatus<?> iStatus = this.getSmoothedStatus();
        if (iStatus instanceof ProductionStatus) {
            ProductionStatus ps = (ProductionStatus)iStatus;
            RenderSystem.m_157456_((int)0, (ResourceLocation)ClientAccess.getArt(this.jobId, ps));
        }
        boolean srcX = false;
        boolean srcY = false;
        Coordinate l = this.topLeft.get();
        int destX = l.x();
        int destY = l.y();
        int drawWidth = 32;
        int drawHeight = 32;
        int texWidth = 32;
        int texHeight = 32;
        Util.blit(stack, destX, destY, (float)srcX, (float)srcY, drawWidth, drawHeight, texWidth, texHeight);
    }

    public boolean renderTooltip(int mouseX, int mouseY, Consumer<ImmutableList<Component>> renderTooltipKey) {
        if (!this.isCoordOnGraphic(mouseX, mouseY)) {
            return false;
        }
        IStatus<?> status = this.getSmoothedStatus();
        ImmutableList<Component> components = JobTooltips.get((ProductionStatus)status, this.jobId);
        renderTooltipKey.accept(components);
        return true;
    }

    private boolean isCoordOnGraphic(int mouseX, int mouseY) {
        Coordinate l = this.topLeft.get();
        Coordinate tl = new Coordinate(l.x(), l.y());
        boolean coordInBox = UtilClean.isCoordInBox(new Coordinate(mouseX, mouseY), tl, tl.shifted(32, 32));
        return coordInBox;
    }

    public boolean mouseClicked(int mouseX, int mouseY) {
        return this.isCoordOnGraphic(mouseX, mouseY);
    }
}

