/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.Jobs;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public record StatusPacket(JobID jobId, ImmutableList<Component> texts, ResourceLocation image) {
    public static void toNetwork(FriendlyByteBuf b, StatusPacket statusPacket) {
        Jobs.writeIdToNetwork(b, statusPacket.jobId);
        b.m_236828_(statusPacket.texts, FriendlyByteBuf::m_130083_);
        b.m_130085_(statusPacket.image);
    }

    public static StatusPacket fromNetwork(FriendlyByteBuf b) {
        JobID j = Jobs.getIdFromNetwork(b);
        List textKeys = b.m_236845_(FriendlyByteBuf::m_130238_);
        ResourceLocation img = b.m_130281_();
        return new StatusPacket(j, (ImmutableList<Component>)ImmutableList.copyOf((Collection)textKeys), img);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusPacket that = (StatusPacket)o;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.image, that.image) && Objects.equals(this.texts, that.texts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.jobId, this.texts, this.image);
    }
}

