/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.Coordinate;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.core.network.EconomicsUpdate;
import ca.bradj.questown.core.network.GiveBOPMessage;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.gui.FlagTabs;
import ca.bradj.questown.gui.IngredientRenderer;
import ca.bradj.questown.gui.ItemEconomicsData;
import ca.bradj.questown.gui.RenderContext;
import ca.bradj.questown.gui.RenderUtil;
import ca.bradj.questown.gui.TownBlockofProgressMenu;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.JEI;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TownBlockofProgressScreen
extends AbstractContainerScreen<TownBlockofProgressMenu> {
    private static final int backgroundWidth = 176;
    private static final int backgroundHeight = 166;
    private final FlagTabs tabs;
    public static EconomicsUpdate lastUpdate = new EconomicsUpdate((ImmutableList<ItemEconomicsData>)ImmutableList.of());
    private final JEI.NineNine background;
    private Button unlockButton;
    IngredientRenderer ingredientRenderer = new IngredientRenderer();
    private int buttonY;
    private int buttonX;

    public TownBlockofProgressScreen(TownBlockofProgressMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.f_97726_ = 256;
        this.f_97727_ = 220;
        this.background = JEI.getRecipeBackground();
        this.tabs = FlagTabs.forMenu(menu);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.unlockButton = (Button)this.m_142416_((GuiEventListener)new Button(0, 0, 168, 20, Compat.translatable("menu.block_of_progress.take"), p_96776_ -> {
            QuestownNetwork.CHANNEL.sendToServer((Object)new GiveBOPMessage(((TownBlockofProgressMenu)this.f_97732_).getFlagInfo().flagPos()));
            Minecraft.m_91087_().m_91152_(null);
        }));
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 81) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_7027_(PoseStack p_97808_, int p_97809_, int p_97810_) {
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.unlockButton.f_93620_ = this.buttonX + 4;
        this.unlockButton.f_93621_ = this.buttonY;
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - 166) / 2;
        bgY += 8;
        int ct = Math.min(((TownBlockofProgressMenu)this.f_97732_).blocksOfProgressCount, 7);
        int iconsX = this.f_96543_ / 2 - 8 * ct;
        for (int i = 0; i < ct; ++i) {
            ItemStack defaultInstance = ((Item)ItemsInit.BLOCK_OF_PROGRESS.get()).m_7968_();
            RenderUtil.renderItemScaled(this.f_96542_, 3, defaultInstance, iconsX + 16 * i, bgY + 2);
        }
        this.renderText(poseStack, bgX, bgY += 24);
    }

    private void renderText(PoseStack poseStack, int bgX, int bgY) {
        Coordinate topLeft = new Coordinate(bgX + 12, bgY);
        int tWidth = 160;
        MutableComponent text = Compat.translatable("menu.block_of_progress.town_has", ((TownBlockofProgressMenu)this.f_97732_).blocksOfProgressCount);
        if (((TownBlockofProgressMenu)this.f_97732_).blocksOfProgressCount == 1) {
            text = Compat.translatable("menu.block_of_progress.town_has_1", ((TownBlockofProgressMenu)this.f_97732_).blocksOfProgressCount);
        }
        bgY += Compat.drawDarkTextWrap(this.f_96547_, poseStack, topLeft.withY(bgY), tWidth, (Component)text);
        bgY += 8;
        bgY += Compat.drawDarkTextWrap(this.f_96547_, poseStack, topLeft.withY(bgY), tWidth, Compat.translatable("menu.block_of_progress.many_uses"));
        this.buttonY = bgY;
        this.buttonX = bgX;
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        int bgX = (this.f_96543_ - 176) / 2;
        int bgY = (this.f_96544_ - 166) / 2;
        this.background.draw(stack, bgX, bgY, 176, 166);
        this.tabs.draw(new RenderContext(this.f_96542_, stack), bgX, bgY);
    }

    public boolean m_7043_() {
        return false;
    }

    public List<Rect2i> getExtraAreas() {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        return ImmutableList.of((Object)new Rect2i(x, y, 176, 166));
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_97750_) {
        int x = (this.f_96543_ - 176) / 2;
        int y = (this.f_96544_ - 166) / 2;
        this.tabs.mouseClicked(x, y, mouseX, mouseY);
        return super.m_6375_(mouseX, mouseY, p_97750_);
    }
}

