/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.init.MenuTypesInit;
import ca.bradj.questown.gui.AbstractQuestsContainer;
import ca.bradj.questown.gui.FlagMenus;
import ca.bradj.questown.gui.FlagTabs;
import ca.bradj.questown.gui.FlagTabsEmbedding;
import ca.bradj.questown.gui.UIQuest;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;

public class TownQuestsContainer
extends AbstractQuestsContainer
implements FlagTabsEmbedding {
    private static final Collection<String> ENABLED_TABS = FlagTabs.allExcept("quests");

    public TownQuestsContainer(int windowId, Collection<UIQuest> quests, FlagTabsEmbedding.FlagInfo flag, Runnable triggerAdvancement) {
        super((MenuType)MenuTypesInit.TOWN_QUESTS.get(), windowId, quests, flag);
        triggerAdvancement.run();
    }

    public static TownQuestsContainer ForClient(int windowId, Inventory inv, FriendlyByteBuf data) {
        FlagMenus menus = FlagMenus.fromNetwork(windowId, inv.f_35978_, data);
        return menus.questsMenu;
    }

    public static void write(FriendlyByteBuf data, List<UIQuest> quests, BlockPos pos) {
        TownQuestsContainer.writeQuests(data, quests);
        TownQuestsContainer.writeFlagPos(data, pos);
    }

    @Override
    public Collection<String> getEnabledTabs() {
        return ENABLED_TABS;
    }

    @Override
    public FlagTabsEmbedding.FlagInfo getFlagInfo() {
        return this.flagInfo;
    }
}

