/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.init.MenuTypesInit;
import ca.bradj.questown.core.network.OpenQuestsMenuMessage;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.core.network.RemoveQuestFromUIMessage;
import ca.bradj.questown.gui.UIQuest;
import ca.bradj.questown.town.special.SpecialQuests;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class TownRemoveQuestsContainer
extends AbstractContainerMenu {
    private final Collection<UIQuest> quests;
    private final BlockPos flagPos;
    private final UUID batchUUID;

    public TownRemoveQuestsContainer(int windowId, Collection<UIQuest> quests, BlockPos flagPos, UUID batchUUID) {
        super((MenuType)MenuTypesInit.TOWN_QUESTS_REMOVE.get(), windowId);
        this.quests = quests;
        this.flagPos = flagPos;
        this.batchUUID = batchUUID;
    }

    public static TownRemoveQuestsContainer read(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new TownRemoveQuestsContainer(windowId, TownRemoveQuestsContainer.readQuests(data), TownRemoveQuestsContainer.readFlagPos(data), data.m_130259_());
    }

    public static void write(FriendlyByteBuf data, List<UIQuest> quests, BlockPos flagPos, UUID batchUUID) {
        TownRemoveQuestsContainer.writeQuests(data, quests);
        TownRemoveQuestsContainer.writeFlagPos(data, flagPos);
        data.m_130077_(batchUUID);
    }

    private static void writeQuests(FriendlyByteBuf data, List<UIQuest> quests) {
        UIQuest.Serializer ser = new UIQuest.Serializer();
        data.writeInt(quests.size());
        data.m_236828_(quests, (buf, q) -> {
            ResourceLocation id;
            if (q == null) {
                id = SpecialQuests.BROKEN;
                q = UIQuest.BROKEN;
            } else {
                id = q.getWantedId();
            }
            buf.m_130085_(id);
            ser.toNetwork((FriendlyByteBuf)buf, (UIQuest)q);
        });
    }

    public static Collection<UIQuest> readQuests(FriendlyByteBuf data) {
        int size = data.readInt();
        ArrayList r = (ArrayList)data.m_236838_(c -> new ArrayList(size), buf -> {
            ResourceLocation recipeID = buf.m_130281_();
            return new UIQuest.Serializer().fromNetwork(recipeID, (FriendlyByteBuf)buf);
        });
        r.sort(UIQuest::compareTo);
        return r;
    }

    private static void writeFlagPos(FriendlyByteBuf data, BlockPos pos) {
        data.writeInt(pos.m_123341_());
        data.writeInt(pos.m_123342_());
        data.writeInt(pos.m_123343_());
    }

    public static BlockPos readFlagPos(FriendlyByteBuf data) {
        return new BlockPos(data.readInt(), data.readInt(), data.readInt());
    }

    public ItemStack m_7648_(Player player, int i) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player p_38874_) {
        return true;
    }

    public Collection<UIQuest> GetQuests() {
        return this.quests;
    }

    public void sendConfirmRemoveRequest() {
        QuestownNetwork.CHANNEL.sendToServer((Object)new RemoveQuestFromUIMessage(this.batchUUID, this.flagPos.m_123341_(), this.flagPos.m_123342_(), this.flagPos.m_123343_(), false));
    }

    public void sendOpenQuestsMenuRequest() {
        QuestownNetwork.CHANNEL.sendToServer((Object)new OpenQuestsMenuMessage(this.flagPos.m_123341_(), this.flagPos.m_123342_(), this.flagPos.m_123343_()));
    }
}

