/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.core.init.MenuTypesInit;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.core.network.RemoveWorkFromUIMessage;
import ca.bradj.questown.gui.AddWorkContainer;
import ca.bradj.questown.gui.UIWork;
import ca.bradj.questown.jobs.requests.WorkRequest;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class TownWorkContainer
extends AbstractContainerMenu {
    private final Collection<UIWork> work;
    public final AddWorkContainer addWorkContainer;
    private final BlockPos flag;
    private boolean skipToAdd;

    public static TownWorkContainer ForClientSide(int windowId, Inventory inv, FriendlyByteBuf buf) {
        AddWorkContainer qMenu = new AddWorkContainer(windowId, AddWorkContainer.readWorkResults(buf), AddWorkContainer.readFlagPosition(buf));
        return new TownWorkContainer(windowId, TownWorkContainer.readWork(buf), qMenu, TownWorkContainer.readFlagPosition(buf), buf.readBoolean());
    }

    private static BlockPos readFlagPosition(FriendlyByteBuf buf) {
        return AddWorkContainer.readFlagPosition(buf);
    }

    public TownWorkContainer(int windowId, Collection<UIWork> quests, AddWorkContainer awc, BlockPos flag, boolean skipToAdd) {
        super((MenuType)MenuTypesInit.TOWN_WORK.get(), windowId);
        this.work = quests;
        this.addWorkContainer = awc;
        this.flag = flag;
        this.skipToAdd = skipToAdd;
    }

    public static Collection<UIWork> readWork(FriendlyByteBuf data) {
        int size = data.readInt();
        return data.m_236838_(c -> new ArrayList(size), buf -> new UIWork(WorkRequest.fromNetwork(buf)));
    }

    public static void writeWork(Collection<WorkRequest> requestedResults, FriendlyByteBuf data) {
        data.writeInt(requestedResults.size());
        data.m_236828_(requestedResults, (buf, w) -> w.toNetwork((FriendlyByteBuf)buf));
    }

    public static void writeFlagPosition(BlockPos townFlagBasePos, FriendlyByteBuf data) {
        AddWorkContainer.writeFlagPosition(townFlagBasePos, data);
    }

    public ItemStack m_7648_(Player player, int i) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player p_38874_) {
        return true;
    }

    public Collection<UIWork> getWork() {
        return this.work;
    }

    public void sendRemoveRequest(UIWork jobPosting) {
        QuestownNetwork.CHANNEL.sendToServer((Object)new RemoveWorkFromUIMessage(jobPosting.getResultWanted(), this.flag.m_123341_(), this.flag.m_123342_(), this.flag.m_123343_()));
    }

    public boolean skipToAdd() {
        return this.skipToAdd;
    }
}

