/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.gui;

import ca.bradj.questown.Questown;
import ca.bradj.questown.blocks.RoomBlock;
import ca.bradj.questown.blocks.entity.BlockAsRoomEntity;
import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.gui.QuestTypes;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.logic.RoomRecipes;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.town.quests.MCQuest;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.MCRewardContainer;
import ca.bradj.questown.town.quests.Quest;
import ca.bradj.questown.town.quests.QuestBatch;
import ca.bradj.questown.town.rewards.ChangeJobReward;
import ca.bradj.questown.town.special.SpecialQuests;
import ca.bradj.roomrecipes.recipes.RecipesInit;
import ca.bradj.roomrecipes.recipes.RoomRecipe;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIQuest
implements Comparable<UIQuest> {
    public static final UIQuest BROKEN = new UIQuest(null, SpecialQuests.BROKEN, Quest.QuestType.UNKNOWN, null, Quest.QuestStatus.ACTIVE, null, null, null);
    public final Quest.QuestStatus status;
    private final ResourceLocation wantedId;
    private final Quest.QuestType type;
    private final ImmutableList<Ingredient> ingredients;
    public final ResourceLocation fromRecipe;
    private final VillagerUUID villagerUUID;
    private final UUID batchUUID;
    private final String jobName;
    public final boolean isBroken;

    public UIQuest(UUID batchUUID, ResourceLocation wantedId, Quest.QuestType type, @Nullable Collection<Ingredient> ingredients, Quest.QuestStatus status, @Nullable ResourceLocation fromRecipe, @Nullable VillagerUUID jobRecipientUUID, @Nullable String jobName) {
        this.isBroken = SpecialQuests.BROKEN.equals((Object)wantedId) || ingredients == null;
        this.wantedId = wantedId;
        this.type = type;
        this.ingredients = ingredients == null ? ImmutableList.of() : ImmutableList.copyOf(ingredients);
        this.status = status;
        this.fromRecipe = fromRecipe;
        this.villagerUUID = jobRecipientUUID;
        this.jobName = jobName;
        this.batchUUID = batchUUID;
    }

    public static List<UIQuest> fromLevel(ServerLevel level, QuestBatch<ResourceLocation, MCRoom, MCQuest, MCReward> batch) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        batch.getAll().forEach(v -> b.put(v, (Object)((MCReward)batch.getReward())));
        return UIQuest.fromLevel((Level)level, (Collection<? extends Map.Entry<? extends Quest<ResourceLocation, MCRoom>, MCReward>>)b.build().entrySet());
    }

    public static List<UIQuest> fromLevel(Level level, Collection<? extends Map.Entry<? extends Quest<ResourceLocation, MCRoom>, MCReward>> aQ) {
        ImmutableMap.Builder rMapB = ImmutableMap.builder();
        SpecialQuests.SPECIAL_QUESTS.forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)rMapB).put(arg_0, arg_1));
        BlockAsRoomEntity.ALL.forEach(v -> {
            RoomBlock vv = (RoomBlock)v.get();
            rMapB.put((Object)RoomBlock.getRoomId(vv), (Object)vv.asRecipe());
        });
        level.m_7465_().m_44013_(RecipesInit.ROOM).forEach(v -> rMapB.put((Object)v.m_6423_(), v));
        ImmutableMap rMap = rMapB.build();
        return aQ.stream().map(z -> {
            Quest v = (Quest)z.getKey();
            @Nullable String job = null;
            MCReward value = (MCReward)z.getValue();
            if (value instanceof ChangeJobReward) {
                ChangeJobReward cjr = (ChangeJobReward)value;
                job = cjr.getJobName();
            }
            if (job == null) {
                job = UIQuest.findJob(value);
            }
            VillagerUUID jobRecipientUUID = null;
            if (v.getUUID() != null) {
                jobRecipientUUID = v.getUUID();
            }
            Collection<Ingredient> ingredientz = UIQuest.getIngredients(v, (ImmutableMap<ResourceLocation, RoomRecipe>)rMap);
            return new UIQuest(v.getBatchUUID(), (ResourceLocation)v.getWantedId(), v.getType(), ingredientz, v.getStatus(), v.fromRecipeID().orElse(null), jobRecipientUUID, job);
        }).toList();
    }

    private static Collection<Ingredient> getIngredients(Quest<ResourceLocation, MCRoom> v, ImmutableMap<ResourceLocation, RoomRecipe> rMap) {
        IForgeRegistry reg = ForgeRegistries.ITEMS;
        return switch (v.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case Quest.QuestType.ROOM -> UIQuest.getRoomIngredients(v, rMap);
            case Quest.QuestType.ITEM -> Collections.nCopies(v.getCountNeeded(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)reg.getValue(v.getWantedId())}));
            case Quest.QuestType.JOB_CHANGE -> ImmutableList.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsInit.BLOCK_OF_PROGRESS.get()}));
            case Quest.QuestType.UNKNOWN -> ImmutableList.of();
        };
    }

    private static Collection<Ingredient> getRoomIngredients(Quest<ResourceLocation, MCRoom> v, ImmutableMap<ResourceLocation, RoomRecipe> rMap) {
        RoomRecipe recip = (RoomRecipe)rMap.get((Object)v.getWantedId());
        if (recip == null) {
            Questown.LOGGER.warn("No recipe found for quest: " + String.valueOf(v.getWantedId()));
            return ImmutableList.of();
        }
        return recip.m_7527_();
    }

    @Nullable
    private static String findJob(MCReward value) {
        String job = null;
        if (value instanceof ChangeJobReward) {
            ChangeJobReward cjr = (ChangeJobReward)value;
            return cjr.getJobName();
        }
        if (value instanceof MCRewardContainer) {
            MCRewardContainer mrc = (MCRewardContainer)((Object)value);
            for (MCReward r : mrc.getContainedRewards()) {
                @Nullable String j = UIQuest.findJob(r);
                if (j == null) continue;
                if (job != null) {
                    Questown.LOGGER.warn("Multiple job change rewards in a single villager quest batch.");
                }
                job = j;
            }
        }
        return job;
    }

    @Override
    public int compareTo(@NotNull UIQuest uiQuest) {
        int sComp = this.status.compareTo(uiQuest.status);
        if (sComp != 0) {
            return sComp;
        }
        return this.type.compareTo(uiQuest.type);
    }

    public ResourceLocation getWantedId() {
        return this.wantedId;
    }

    public Collection<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public Component getName() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Quest.QuestType.ROOM -> RoomRecipes.getName(this.wantedId);
            case Quest.QuestType.ITEM -> Compat.translatable("menu.common.quantity", Compat.getItemName(this.wantedId), this.ingredients.size());
            case Quest.QuestType.JOB_CHANGE -> Compat.translatable("questown.menu.quests.job_change", this.extractJobName());
            case Quest.QuestType.UNKNOWN -> Compat.literal("ERROR");
        };
    }

    private String extractJobName() {
        return JobID.fromRL(this.wantedId).jobId();
    }

    public String jobName() {
        return this.jobName;
    }

    public String villagerUUID() {
        return VillagerUUID.getStringUUID(this.villagerUUID);
    }

    public UUID getBatchUUID() {
        return this.batchUUID;
    }

    public Quest.QuestType getType() {
        return this.type;
    }

    public static class Serializer {
        public void toNetwork(FriendlyByteBuf buf, UIQuest p_44102_) {
            buf.m_130070_(p_44102_.status.asString());
            buf.m_130085_(p_44102_.wantedId);
            QuestTypes.toNetwork(buf, p_44102_.type);
            buf.m_236828_(p_44102_.ingredients, (b, i) -> Ingredients.toNetwork(i, b));
            String fromStr = "";
            if (p_44102_.fromRecipe != null) {
                fromStr = p_44102_.fromRecipe.toString();
            }
            buf.m_130070_(fromStr);
            VillagerUUID.toNetwork(buf, p_44102_.villagerUUID);
            String jobName = "";
            if (p_44102_.jobName != null) {
                jobName = p_44102_.jobName;
            }
            buf.m_130070_(jobName);
            buf.m_130070_(p_44102_.batchUUID == null ? "" : p_44102_.batchUUID.toString());
        }

        @Nullable
        public UIQuest fromNetwork(ResourceLocation p_44105_, FriendlyByteBuf buf) {
            Quest.QuestStatus status = Quest.QuestStatus.fromString(buf.m_130277_());
            ResourceLocation wanteId = buf.m_130281_();
            Quest.QuestType type = QuestTypes.fromNetwork(buf);
            List ingrs = buf.m_236845_(Ingredients::fromNetwork);
            String fromStr = buf.m_130277_();
            ResourceLocation from = null;
            if (!fromStr.isEmpty()) {
                from = new ResourceLocation(fromStr);
            }
            VillagerUUID villagerUUID = VillagerUUID.fromNetwork(buf);
            String jobName = buf.m_130277_();
            String maybeBatchUUID = buf.m_130277_();
            UUID batchUUID = null;
            if (!maybeBatchUUID.isEmpty()) {
                batchUUID = UUID.fromString(maybeBatchUUID);
            }
            return new UIQuest(batchUUID, wanteId, type, ingrs, status, from, villagerUUID, jobName);
        }
    }
}

